
%   This function is to set up parameters to run SDTP3 to solve 
%   y'Ay + b'y , where A is size of m^2*m^2, we used the exactly notations 
%   as in the paper.
%   make sure SDTP3 is installed.
%     
%    first,  [blk,At,C,bt] = clcPr(A, b);
%    then, run SDTP3 like this: [obj1,X1,y1,Z1,info1] = sqlp(blk,At,C,bt);
%   
%   by Xiao-Ming Wu at wxm007@ie.cuhk.edu.hk 

function [blk,At,C,bt] = clcPr(A, b)
  
   % Cholesky decomposition
   B = cholpp(A);
  
   q = size(B,1);       % the rank of A
   n = sqrt(size(B,2)); 
   s = n*(n+1)/2;

   % collect parameters for semidefinite block
   blk{1,1} = 's'; blk{1,2} = n;
   
   for k=1:q;   
       tp = reshape(B(k,:), [n,n]);
       tp = (tp+tp')/2;   
       AA{1,k} = tp;   
   end;
   
   matrepdiag = svec(blk(1,:), AA); 
   At{1,1} = [zeros(s,1), matrepdiag{1}];
   
   % collect parameters for quadratic block
   blk{2,1} = 'q'; blk{2,2} = q+2;
   At{2,1} = [1,1, zeros(1, q); zeros(q,2), -1*speye(q)]; 
   
   bt = [1; zeros(q,1)];
 
   % collect parameters for the objective function
   tmp = reshape(b, [n,n]);
   tmp = (tmp + tmp')/2; 
   C{1,1} = tmp; 
   C{2,1} = [1; -1; zeros(q,1)]; 


