function [W, G] = SDPP_grad(X, Y, W0, G0, bKernel, length, lambda, ...
    boolClassification, Sparse, targetDimension, verbose)

% SDPP optimization based on conjugate gradient descent. 
% Mika Juuti et al. 2014-09-22

[n, d] = size(X);
W = W0;
G = G0;

if nargin < 11
    verbose = 0;
end

nn = nnz(G);
if Sparse==-1
    if nn / n^2 <= 0.05 && ~bKernel
        Sparse = 1;
    else
        Sparse = 0;
    end
end

if ~Sparse
    if ~bKernel
        Dy = distSqrdSelf(Y);
    else % the supplied X and Y are actually kernels
        Dy = diag(Y)*ones(1,n) + ones(n,1)*diag(Y)' - 2*Y;
    end
else
    G = sparse(G);
    Dy = distSqrdSelfsparse(Y,G);
end

if boolClassification
    Dy(Dy~=0)= 1;
end

    partLength = size(W0,1);
    if partLength > length
        partLength = length;
        parts = 1;
    else
        parts = ceil(length/partLength);
    end

    remainderLength = length - parts*partLength;

if Sparse
    if verbose
        disp('Using sparse matrix calculations.')
    end

    fOld = obj_SDPP_sparse(W, X, Dy, G, n, lambda);
    for i=1:parts
        if i~= parts || (i==parts && remainderLength==0)
            [W, fW, ii] = minimize(W(:,1:targetDimension), 'obj_SDPP_sparse', partLength, X, Dy, G, n, lambda);
        else
            [W, fW, ii] = minimize(W(:,1:targetDimension), 'obj_SDPP_sparse', remainderLength, X, Dy, G, n, lambda);
        end
        fNew = fW(end);
        if abs(fNew - fOld) < 1e-8
            break;
        else
           fOld = fNew; 
        end
    end
    
    %[W, fW, ii] = minimize(W(:,1:targetDimension), 'obj_SDPP_sparse', length, X, Dy, G, n, lambda);
else
    if verbose
        disp('Using dense matrix calculations.')
    end
    
    fOld = obj_SDPP(W, X, Dy, G, n, lambda);
    for i=1:parts
        if i~= parts || (i==parts && remainderLength==0)
            [W, fW, ii] = minimize(W(:,1:targetDimension), 'obj_SDPP', partLength, X, Dy, G, n, lambda);
        else
            [W, fW, ii] = minimize(W(:,1:targetDimension), 'obj_SDPP', remainderLength, X, Dy, G, n, lambda);
        end
        fNew = fW(end);
        if abs(fNew - fOld) < 1e-8
            break;
        else
           fOld = fNew; 
        end
    end
    %[W, fW, ii] = minimize(W(:,1:targetDimension), 'obj_SDPP', length, X, Dy, G, n, lambda);
end

end