// Copyright 1998 by Patrik Simons
// This software is provided as is, no warranty of any kind is given.
#include <iostream.h>
#include <stdlib.h>
#include "stable.h"

Stable::Stable ()
  : reader (&smodels.program)
{
}

Stable::~Stable ()
{
}

int
Stable::read (istream &f)
{
  timer.start ();
  int r = reader.read (f);
  if (r == 0)
    {
      smodels.init ();
      smodels.max_models = reader.models;
    }
  return r;
}

int
Stable::tries (bool lookahead, bool backjumping, long max_conflicts,
	       long max_tries, long seed)
{
  srand (1);   // Reset
  srand (seed);
  smodels.setup ();
  int r = smodels.conflict ();
  long tries;
  for (tries = 0; tries < max_tries && !r; tries++)
    {
      smodels.shuffle ();
      r = smodels.smodels (lookahead, backjumping, max_conflicts);
    }
  if (tries == 0 || r == -1)
    return 0;
  else
    return 1;
}

void
Stable::calculate (bool w, bool lookahead, bool backjumping,
		   bool sloppy_heuristic, 
		   long max_conflicts, long max_tries, long seed)
{
  int r;
  smodels.sloppy_heuristic = sloppy_heuristic;
  if (w)
    r = smodels.wellfounded ();
  else if (max_conflicts == 0)
    {
      if (seed != 1)
	{
	  srand (1);   // Reset
	  srand (seed);
	  smodels.shuffle ();
	}
      r = smodels.smodels (lookahead, backjumping);
    }
  else
    r = tries (lookahead, backjumping, max_conflicts, max_tries, seed);
  if (r)
    cout << "True" << endl;
  else
    cout << "False" << endl;
  timer.stop ();
  cout << "Duration: " << timer.print () << endl;
  cout << "Number of choice points: " <<
    smodels.number_of_choice_points << endl;
  cout << "Number of wrong choices: " <<
    smodels.number_of_wrong_choices << endl;
  cout << "Number of atoms: " << smodels.program.number_of_atoms <<
    endl;
  cout << "Number of rules: " << smodels.program.number_of_rules <<
    endl;
  if (lookahead)
    {
      cout << "Number of picked atoms: " <<
	smodels.number_of_picked_atoms << endl;
      cout << "Number of forced atoms: " <<
	smodels.number_of_forced_atoms << endl;
      cout << "Number of truth assignments: " <<
	smodels.number_of_assignments << endl;
    }
  if (backjumping)
    cout << "Number of backjumps: " << smodels.number_of_backjumps <<
      endl;
}
