// Copyright 1998 by Patrik Simons
// This software is provided as is, no warranty of any kind is given.
#include <iostream.h>
#include "program.h"
#include "atomrule.h"

Program::Program ()
{
  optimize = 0;
  number_of_atoms = 0;
  number_of_rules = 0;
  number_of_heads = 0;
  size_of_program = 0;
  conflict = false;
}

Program::~Program ()
{
}

void
Program::init ()
{
  equeue.Init (number_of_atoms);
  queue.Init (number_of_heads);
}

void
Program::print ()
{
  Node *n;
  for (n = rules.head; n; n = n->next)
    {
      if (n->rule->isInactive ())
	continue;
      n->rule->print ();
    }
  for (n = atoms.head; n; n = n->next)
    if (n->atom->computeTrue || n->atom->computeFalse)
      break;
  if (n == 0)
    return;
  cout << "compute { ";
  bool comma = false;
  for (n = atoms.head; n; n = n->next)
    {
      if (n->atom->computeTrue)
	{
	  if (comma)
	    cout << ", ";
	  cout << n->atom->atom_name ();
	  comma = true;
	}
      if (n->atom->computeFalse)
	{
	  if (comma)
	    cout << ", ";
	  cout << "not " << n->atom->atom_name ();
	  comma = true;
	}
    }
  cout << " }" << endl;
}
