/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* mca.c                     */
/* Burkhard Graves, 08.04.95 */
/*****************************/

#include <ctype.h>
#include "mca.h"
#include "l1_mc.h"
#include "l2_mc.h"
#include "relation.h"
#include "basic_lf.h"
#include "y_tab.h"

/********************/
/* Globale Variable */
/********************/

  TreeNode *tree;               /* der Syntaxbaum der Formel              */
BraProcess *bprocess;           /* der Branchingprozess                   */
       Set *cutoffs;            /* die Cutoff-Events                      */
       Set *min;                /* das Minimum des Branchingprozesses     */
       Set *initial_marking;    /* die Beschriftung des Minimums          */
     SList *max_configs;        /* die maximalen Konfigurationen          */
  unsigned anz_max_configs;     /* die Anzahl der max. Konfigurationen    */
  unsigned multi;               /* zaehlt die Konjunktionsglieder         */
                                /* (extern)                               */

  Wanted *first,*last;
     int count_wanted;
     Set *help1,*help2;   /* fuer sub_causes(), Causes(), CausesInSet()   */
unsigned gflag;           /* globales Flag                                */

/**************************************************************************/
/* Kopiert die Beschriftungen der Bedingungen in der Menge 'conditions'   */
/* in die Menge 'labels'.                                                 */
/**************************************************************************/
 
void LCondInSet(Set *labels,Set *conditions)
{
    unsigned condition;
    Condition *cond;
 
    SetClear(labels);
    cond=bprocess->conditions;
    condition=0;
    for (;;) {
        condition=SetGetElementNext(conditions,++condition);
        if (!condition)
            break;
        SetInsertElement(labels,(cond+condition)->pl_numname);
    }
}

/**************************************************************************/
/* Berechnet die Beschriftungen der Bedingungen in der Menge 'conditions'.*/
/**************************************************************************/
 
Set *LCond(Set *conditions)
{
    Set *labels;
 
    LCondInSet(labels=SetCreate(),conditions);
    return labels;
}

/**************************************************************************/
/* Berechnung des Minimums des Branchingprozesses.                        */
/**************************************************************************/
 
Set *Min(BraProcess *bprocess)
{
    Set       *min;
    Condition *pl;
 
    min=SetCreate();
    pl=bprocess->conditions; /* Achtung: bprocess->conditions zeigt vor */
    ++pl;                    /* die erste Bedingung !                  */
    while (pl) {
        if (!pl->preset)
            SetInsertElement(min,pl->numname);
        pl=pl->next;
    }
    return min;
}
 
/**************************************************************************/
/* Der L1-L2-Modelchecker                                                 */
/**************************************************************************/

int ModelChecker(void)
{
    return 0;
}

/*********************/
/* END OF FILE mca.c */
/*********************/
