// Copyright 1998,2000 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#include "alloc.h"
#include "dassert.h"
#include "sarray.h"
#include "ulhsort.h"

SARRAY *CreateSArray(unsigned long size)
{
  SARRAY *sarray;
  
  sarray = (SARRAY *)xmalloc(sizeof(SARRAY) +
			     ((size -1) *
			      sizeof(SARRAY_ELEMENT)));

  sarray->curr_saitem = &sarray->saitems[0];

  return (sarray);
}


SARRAY *CopySArray(SARRAY *src)
{
  SARRAY *dst;
  unsigned long size;
  unsigned long i;

  size = GetSArraySize(src);

  dst = (SARRAY *)xmalloc(sizeof(SARRAY) +
			  ((size -1) *
			   sizeof(SARRAY_ELEMENT)));

  dst->curr_saitem = &dst->saitems[size];

  for(i = 0; i < size; i++) {
    dst->saitems[i] = src->saitems[i];
  }

  return (dst);



}


void SortSArray(SARRAY *sarray)
{
  unsigned long size;

  size = GetSArraySize(sarray);
  if(size > 1) {
    ULHeapSort(&(sarray)->saitems[0], size);
  }

}
