// Copyright 2000 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#ifndef MSET_H
#define MSET_H

#include "combi.h"
#include "bitarr.h"

typedef unsigned long MSET_ITEM;

typedef struct mset
{
  MSET_ITEM *mset_counts;   /* Multi set counts */
  BITARRAY *mdirtybits;     /* Dirty bits */
  MSET_ITEM *mcurr_item;
  BOOL dirty_mset;          /* Have any removes been done to the multiset? */
  MSET_ITEM mitems[1];
} MSET;


#define AddOnetoMSet(mset, item) \
((mset)->mset_counts[(item)]++, \
 (GetBit((mset)->mdirtybits, (item)) ? \
  (TRUE) : \
  (SetBit((mset)->mdirtybits, (item)), \
   *(mset)->mcurr_item++ = (item))))

#define RemoveOnefromMSet(mset, item) \
((mset)->mset_counts[(item)]--, \
 (mset)->dirty_mset = TRUE)

#define EmptyMSet(mset) \
(((mset)->dirty_mset == FALSE) ? \
 (((mset)->mcurr_item == (&(mset)->mitems[0])) ? \
  (TRUE) : (FALSE)) : \
 (DirtyEmptyMSet(mset)))

#define GetMSetSize(mset) \
(((mset)->dirty_mset == FALSE) ? \
 ((unsigned long)((mset)->mcurr_item - (&(mset)->mitems[0]))) : \
 (DirtyGetMSetSize(mset)))

#define GetMSetItem(mset, item) \
(GetMSetSize(mset), (mset)->mitems[(item)])

#define GetMSetItems(mset) \
(GetMSetSize(mset), &(mset)->mitems[0])

#define GetMSetCount(mset, idx) \
((mset)->mset_counts[(idx)])

#define GetMSetItemCount(mset, item) \
(GetMSetSize(mset), (mset)->mset_counts[(mset)->mitems[(item)]])

#define AddCounttoMSet(mset, item, count) \
((mset)->mset_counts[(item)] += (count), \
 (GetBit((mset)->mdirtybits, (item)) ? \
  (TRUE) : \
  ((count == 0) ? \
   (TRUE) : \
   (SetBit((mset)->mdirtybits, (item)), \
    *(mset)->mcurr_item++ = (item)))))


MSET *CreateMSet(unsigned long domainsize);
void DeleteMSet(MSET *mset);

void ClearMSet(MSET *mset);
void SortMSet(MSET *mset);
MSET *CopyMSet(MSET *src);


/* For internal use only! */

unsigned long DirtyGetMSetSize(MSET *mset);
BOOL DirtyEmptyMSet(MSET *mset);

#endif /* MSET_H */
