#include "mset.h"
#include "alloc.h"
#include "dassert.h"
#include "ulhsort.h"

MSET *CreateMSet(unsigned long domainsize)
{
  unsigned long i;
  MSET *mset;

#if 0
  ASSERT(domainsize != 0);
#endif
  MSET_ITEM *mcounts;

  mset = (MSET *)xmalloc(sizeof(MSET) +
			 ((domainsize -1) * sizeof(MSET_ITEM)));

  mset->mset_counts = (MSET_ITEM*)xmalloc(domainsize * sizeof(MSET_ITEM));
  mset->mdirtybits = CreateBitArray(domainsize);
  mset->mcurr_item = &mset->mitems[0];
  mset->dirty_mset = FALSE;

  // Have to clear the counts to zero

  mcounts = mset->mset_counts;
  for(i = 0; i < domainsize; i++) {
    mcounts[i] = 0;
  }

  return (mset);

}

void ClearMSet(MSET *mset)
{
  MSET_ITEM *mcurr_item;
  MSET_ITEM *mitems;
  MSET_ITEM *mcounts;
  MSET_ITEM item;
  BITARRAY *mdirtybits;

  mcounts = mset->mset_counts;
  mdirtybits = mset->mdirtybits;
  mcurr_item = mset->mcurr_item;
  mitems = &mset->mitems[0];
  mset->mcurr_item = mitems;
  mset->dirty_mset = FALSE;

  while(mcurr_item != mitems) {

    mcurr_item--;
    item = *mcurr_item;

    mcounts[item] = 0;
    ClearBit(mdirtybits, item);

  }

}

void DeleteMSet(MSET *mset)
{

  DeleteBitArray(mset->mdirtybits);
  free(mset->mset_counts);
  free(mset);

}


/* For internal use only! */

unsigned long DirtyGetMSetSize(MSET *mset)
{
  MSET_ITEM *mcurr_item;
  MSET_ITEM *mitems;
  MSET_ITEM *mitems2;
  MSET_ITEM *mset_counts;
  MSET_ITEM mitem;
  BITARRAY *mdirtybits;
  unsigned long size;

  mset_counts = mset->mset_counts;
  mdirtybits = mset->mdirtybits;
  mcurr_item = mset->mcurr_item;
  mitems = &mset->mitems[0];
  mitems2 = mitems;

  ASSERT(mcurr_item != mitems);

  for(size = 0; mitems != mcurr_item; mitems++) {

    mitem = *mitems;

    if(mset_counts[mitem] != 0) {

      // This item belongs to the multi-set

      size++;

      if(mitems2 != mitems) {

	// Do a write only if change is needed

	*mitems2 = mitem;
      }

      mitems2++;

    } else {

      // This item has been removed from the multi-set

      ClearBit(mdirtybits, mitem);

    }

  }

  mset->mcurr_item = mitems2;
  mset->dirty_mset = FALSE;

  return size;

}


void SortMSet(MSET *mset)
{
  unsigned long size;

  size = GetMSetSize(mset); // Will do cleaning up if necessary!

  // The multi-set is clean, just sort the items!
  if(size > 1) {
    ULHeapSort(&mset->mitems[0], size);
  }

}

MSET *CopyMSet(MSET *src)
{
  unsigned long i;
  unsigned long size;
  unsigned long domainsize;
  unsigned long count;
  unsigned long item;
  MSET *dst;

  domainsize = GetBitArraySize(src->mdirtybits);

  dst = CreateMSet(domainsize);

  size = GetMSetSize(src);
  for(i = 0; i < size; i++) {
    item = GetMSetItem(src, i);
    count = GetMSetCount(src, item);
    AddCounttoMSet(dst, item, count);
  }

  return(dst);

}


/* For internal use only! */

BOOL DirtyEmptyMSet(MSET *mset)
{
  BOOL empty;
  unsigned long size;

  size = DirtyGetMSetSize(mset);

  empty = ((size == 0) ? (TRUE) : (FALSE));

  return empty;
  
}
