/*
 * Main routines:
 *
 * Copyright Keijo Heljanko <Keijo.Heljanko@hut.fi>
 *
 * Smodels:
 *
 * Copyright Patrik Simons <Patrik.Simons@hut.fi>
 *
 */


#include <stdio.h>
#include <string.h>
#include "combi.h"
#include "main.h"
#include "dassert.h"
#include "ptnet.h"
#include "unfold.h"

// Include the smodels stuff.

#include <iostream.h>
#include "stable.h"
#include "api.h"
#include "timer.h"
#if defined _BSD_SOURCE || defined _SVID_SOURCE || defined __SVR4
#include <sys/time.h>
#include <sys/resource.h>
#endif

static void usage(char *myname)
{
    fprintf(stderr,"============================================================================\n");
    fprintf(stderr,"Safe net unfolder and LTL checker (Smodels based)\n");
    fprintf(stderr,"Usage: %s [OPTION]... file1 [file2]\n",myname);
    fprintf(stderr,"\n");
    fprintf(stderr,"Options:\n");
    fprintf(stderr,"        -m=<mci_file> : Output the prefix in '.mci' file format\n");
    fprintf(stderr,"        -l            : Do LTL model checking\n");
//    fprintf(stderr,"        -n            : Use smodels with no lookahead (fast for easy examples)\n");
    fprintf(stderr,"        -v            : Give verbose statistics\n");
    fprintf(stderr,"\n");
    fprintf(stderr,"        file1         : input file containing unfolding\n");
    fprintf(stderr,"                        extension '.ll_net': PEP low level net\n");
    fprintf(stderr,"        file2         : output result file\n");
    fprintf(stderr,"\n");
    fprintf(stderr,"Copyright (c) 1998-2001 Keijo Heljanko <Keijo.Heljanko@hut.fi> (unfolder)\n");
    fprintf(stderr,"Copyright (c) 1998-2000 Patrik Simons <Patrik.Simons@hut.fi> (smodels)\n");
    fprintf(stderr,"\n");
    fprintf(stderr,"Version 0.9, smodels version 2.26, (%s)\n", __DATE__);
    fprintf(stderr,"============================================================================\n");

}

int main (int argc, char *argv[])
{
  FILE * in;
  FILE * mci_out;
  char * input_file;
  char * output_file;
  char * mci_file;
  BOOL verbose;
  BOOL error;
  BOOL debugging;
  BOOL lookahead;
  BOOL do_ltl;
  Timer timer1;
#if 0
#if defined _BSD_SOURCE || defined _SVID_SOURCE || defined __SVR4
  struct rusage rusage1;
#endif
#endif
  PTNet *net;
  Prefix *prefix;
  Unfolder *unfolder;

  timer1.start();
  
  lookahead = TRUE;
  debugging = FALSE;
  verbose = FALSE;
  error = FALSE;
  do_ltl = FALSE;

  in = (FILE *)NULL;
  mci_out = (FILE *)NULL;
  input_file = (char *)NULL;
  output_file = (char *)NULL;
  mci_file = (char *)NULL;

  net = (PTNet *)NULL;

  for (int c = 1; c < argc && error == FALSE; c++) {
    if (argv[c][0] == '-') {
       if (strncmp (&argv[c][1], "m=", 2) == 0) {
        mci_file = &argv[c][3];
      } else if(strcmp (&argv[c][1], "l") == 0) {
	do_ltl = TRUE;
#if 0
      } else if(strcmp (&argv[c][1], "n") == 0) {
	lookahead = FALSE; // Currently always enabled!
#endif
     } else if(strcmp (&argv[c][1], "d") == 0) {
	debugging = TRUE;
      } else if(strcmp (&argv[c][1], "v") == 0) {
	verbose = TRUE;
      } else {
	error = TRUE;
      }
    } else {
      if(input_file == NULL) {
	input_file = argv[c];
      } else if(output_file == NULL) {
	output_file = argv[c];
      } else {
	error = TRUE;
	break;
      }
    }
  }

  if(input_file == NULL) {
    error = TRUE;
  }


  if(error != FALSE) {
    usage(argv[0]);
    exit(1);
  }
    
  if((in = fopen(input_file, "rb")) == NULL) {

    fprintf(stderr, "%s: No such PEP low level net file: %s\n", argv[0], input_file);
    exit(1);
   
  }

  if(output_file != NULL) {

    if(freopen(output_file, "wb", stdout) == NULL) {

      fprintf(stderr, "%s: Could not open output file: %s\n", argv[0], output_file);
      exit(1);
   
    }
    
  }

  if(mci_file != NULL) {

    if((mci_out = fopen(mci_file, "wb")) == NULL) {

      fprintf(stderr, "%s: Could not create '.mci' output file: %s\n", argv[0], mci_file);
      exit(1);
   
    }
    
  }

  if((do_ltl == FALSE) &&
     (mci_out == NULL)) {

      fprintf(stderr, "%s: Mci output file not specified\n", argv[0]);
      exit(1);

  }
  
  net = new PTNet(do_ltl);

  if(net->ReadPEP(in) == FALSE) {

    fprintf(stderr, "%s: Error while parsing PEP low level net file: %s\n", argv[0], input_file);

    delete(net);
    exit(1);

  }

  unfolder = new Unfolder(net, debugging, do_ltl);

  prefix = unfolder->Unfold();

  if(verbose != FALSE) {
    fprintf(stdout, "\nPrefix generation statistics:\n");
    fprintf(stdout, "|S|= %lu, |T|= %lu, |B|= %lu, |E|= %lu, Cutoffs= %lu\n",
	    net->getNumPlaces(),
	    net->getNumTransitions(),
	    prefix->getNumAddedConditions(),
	    prefix->getNumAddedEvents(),
	    prefix->getNumAddedCutOffs());
    fprintf(stdout, "\n");

    if(do_ltl != FALSE) {

      prefix->PrintLTLStats();
      
    }

    fflush(stdout);
  }

  if(mci_out != NULL) {

    if(prefix->WriteMciFile(mci_out) == FALSE) {

      fprintf(stderr, "%s: Error while writing '.mci' output file: %s\n", argv[0], mci_file);
      fclose(mci_out);

      delete(prefix);
      delete(unfolder);
      delete(net);
      exit(1);
   
    }
    
    fclose(mci_out);

  }
  
  delete(prefix);
  delete(unfolder);
  delete(net);


  fflush(stdout);
    
  timer1.stop();
#if 0
#if defined _BSD_SOURCE || defined _SVID_SOURCE || defined __SVR4
  getrusage (RUSAGE_SELF, &rusage1);
  fprintf(stdout,
	  "\nTime needed:      %lu.%.3lu\n",
	  rusage1.ru_utime.tv_sec +
	  rusage1.ru_stime.tv_sec +
	  ((rusage1.ru_utime.tv_usec +
	    rusage1.ru_stime.tv_usec)
	   / 1000000),
	  ((((rusage1.ru_utime.tv_usec +
	      rusage1.ru_stime.tv_usec)
	     / 1000) < 1000) ?
	   ((rusage1.ru_utime.tv_usec +
	     rusage1.ru_stime.tv_usec)
	    / 1000) :
	   (((rusage1.ru_utime.tv_usec +
	      rusage1.ru_stime.tv_usec)
	     / 1000) - 1000)));
#else
  fprintf(stdout, "\nTime needed:      %s s\n", timer1.print());
#endif
#endif    
  fflush(stdout);
    
  if(output_file != NULL) {
    fclose(stdout);
  }
  
  fclose(in);
  
  exit(0);

}


