#ifndef EVENTQUEUE_H
#define EVENTQUEUE_H

#include <stdio.h>
#include "combi.h"

class Prefix;

#define EVENTQUEUE_MINALLOC 4

typedef struct event_queue_info
{
  unsigned long idx;               // The index of the event
  unsigned long L_event_idx;       // The idx of the L-event in this config,
                                   // or ULONG_MAX if none
  unsigned long local_config_size; // Number of events in [e]
  unsigned long num_I_events;      // Number of I-events in [e]
  unsigned long *parikh;           // Parikh vector as: <num, <t1,c1>, ..., <tn,cn>>
  unsigned long *foata;            // The Foata levels as: <numlevels,
                                   //                      <l1size, <t1,t2, ..., tn>>,
                                   //                      <l2size, ...>, ..., <lmsize, ...>>
} EVENT_QUEUE_INFO;                // (In all of the above: Sorted in increasing order
                                   //  of transition index, only non-zero counts included.)

class EventQueue
{
public:

  EventQueue(Prefix *prefix, BOOL do_ltl);
  ~EventQueue();

  BOOL Empty(void) {return ((size == 0) ? (TRUE) : (FALSE));};
  unsigned long GetSize(void) {return (size);};
  unsigned long GetItem(unsigned long index) {return (infos[index]->idx);};
  unsigned long PeekSmallest(void) {return (infos[0]->idx);};

  void Add(unsigned long event);
  unsigned long RemoveSmallest(void);

  int CompareInfos(EVENT_QUEUE_INFO *i1,
		   EVENT_QUEUE_INFO *i2);

protected:

  int CompareERV(EVENT_QUEUE_INFO *i1,
		 EVENT_QUEUE_INFO *i2);

  Prefix *prefix;

  unsigned long size;
  unsigned long alloc_size;

  EVENT_QUEUE_INFO **infos;

  BOOL do_ltl;

};

#endif /* EVENTQUEUE_H */
