// Copyright 2000 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#ifndef DSET_H
#define DSET_H

#include "combi.h"
#include "bitarr.h"
#include "darray.h"

#define DSET_DEFAULT_MIN_SIZE 32

typedef struct dset
{
  unsigned long domainsize;
  BITARRAY *dsetbits;
  DARRAY *dset_items;
  BOOL dirty_dset;
} DSET;


#define AddtoDSet(dset, item) \
(((item >= (dset)->domainsize) ? (ExpandDSet((dset), (item)), (TRUE)) : (TRUE)), \
 (SetBit((dset)->dsetbits, ((item)*2)), \
  (GetBit((dset)->dsetbits, (((item)*2)+1)) ? \
   (TRUE) : \
   (SetBit((dset)->dsetbits, (((item)*2)+1)), \
    AppendDArray((dset)->dset_items, (item))))))

#define GetDSetSize(dset) \
(((dset)->dirty_dset == FALSE) ? \
 (GetDArraySize((dset)->dset_items)) : (DirtyGetDSetSize(dset)))

#define GetDSetItem(dset, index) \
(GetDArrayItem(((dset)->dset_items), (index)))

#define InDSet(dset, item) \
(((item) >= (dset)->domainsize) ? (FALSE) : (GetBit((dset)->dsetbits, ((item)*2))))
     
DSET *CreateDSet(unsigned long domainsize = DSET_DEFAULT_MIN_SIZE);
void DeleteDSet(DSET *dset);


/* For internal use only! */

void ExpandDSet(DSET *dset, unsigned long item);
unsigned long DirtyGetDSetSize(DSET *dset);

#endif /* DSET_H */
