#include "dset.h"
#include "alloc.h"
#include "dassert.h"



DSET *CreateDSet(unsigned long domainsize = DSET_DEFAULT_MIN_SIZE)
{
  DSET *dset;
  ASSERT(domainsize != 0);

  dset = (DSET *)xmalloc(sizeof(DSET));
  dset->domainsize = domainsize;
  dset->dsetbits = (BITARRAY *)CreateBitArray(domainsize*2);
  dset->dset_items = (DARRAY *)CreateDArray();
  dset->dirty_dset = FALSE;

  return dset;

}


void DeleteDSet(DSET *dset)
{

  DeleteDArray(dset->dset_items);
  DeleteBitArray(dset->dsetbits);
  free(dset);

}

/* For internal use only! */

void ExpandDSet(DSET *dset, unsigned long item)
{
  unsigned long i;
  unsigned long domainsize;
  unsigned long size;
  unsigned long it;
  DARRAY *da;

  domainsize = dset->domainsize;

  while(domainsize <= item) {

    domainsize *= 2;

  }

  size = GetDSetSize(dset);

  DeleteBitArray(dset->dsetbits);
  dset->domainsize = domainsize;
  dset->dsetbits = CreateBitArray(domainsize*2);

  da = dset->dset_items;
  for(i = 0; i < size; i++) {

    it = GetDArrayItem(da, i);
    SetBit((dset)->dsetbits, ((it)*2));

  }

}


/* For internal use only! */

unsigned long DirtyGetDSetSize(DSET *dset)

{
  unsigned long i;
  unsigned long item;
  unsigned long size;
  DARRAY *da;
  BITARRAY *dsetbits;

  dsetbits = dset->dsetbits;
  da = dset->dset_items;
  for(i = 0, size = 0;;) {

    if(i >= GetDArraySize(da)) {
      break;
    }

    item = GetDArrayItem(da, i);

    if(GetBit(dsetbits, (2*item)) != FALSE) {

      // This item belongs to the set

      size++;
      i++;

    } else {

      // This item has been removed from the set

      ClearBit(dsetbits, ((2*item)+1));

      RemDArrayItem(da, i);

    }

  }

  dset->dirty_dset = FALSE;

  return size;

}
