// Copyright 1998,2000 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#ifndef DHASH_H
#define DHASH_H

#include "combi.h"
#include "ulhash.h"

#define DYN_HASH_MINSIZE 16
#define DYN_HASH_DATA unsigned long

typedef struct dyn_hash_table_item
{
  DYN_HASH_DATA * data;            /* Actual data. */
  unsigned long signature;         /* Full hash signature to minimize key
				      comparisons. If comparisons are
				      cheap, make another hash routine
                                      where this signature is recalculated
                                      when needed. */
} DYN_HASH_ITEM;

typedef struct dyn_hash_table
{
  unsigned long array_items;       /* The number of items allocated. */
  unsigned long mask;              /* The mask used. */
  unsigned long max_items;         /* The max number of items used by array. */
  unsigned long num_items;         /* The number of items used by array. */
  DYN_HASH_ITEM *items;            /* Pointer to the hash array. */ 
} DYNHASH;


DYNHASH *CreateDynhash(unsigned long initial_items);
void DeleteDynhash(DYNHASH *hash);
void ClearDynhash(DYNHASH *hash);
BOOL InsertDataTellIfNew(DYNHASH *hash, DYN_HASH_DATA *data);
DYN_HASH_DATA *InsertDataIfNew(DYNHASH *hash, DYN_HASH_DATA *data);



// Internal implementation stuff

void ExpandDynHash(DYNHASH *hash);
void ExpandRehashDynHash(DYNHASH *hash);

#endif DHASH_H
