// Copyright 1998,2000 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#include "combi.h"

#ifndef DARRAY_H
#define DARRAY_H

#define DARRAY_MINSIZE 4  /* A small power of two will do nicely */

typedef unsigned long DARRAY_ELEMENT;

typedef struct DARRAY
{
  DARRAY_ELEMENT *curr_ditem;     /* The current darray pointer */
  DARRAY_ELEMENT *last_ditem;     /* The last item */
  DARRAY_ELEMENT *ditems;
} DARRAY;


#define DArrayEmpty(darray) \
(((darray)->curr_ditem == (&(darray)->ditems[0])) ? (TRUE) : (FALSE))

#define AppendDArray(darray, i1) \
((*(darray)->curr_ditem = ((DARRAY_ELEMENT)(i1))), \
 (((darray)->curr_ditem++ == (darray)->last_ditem) ? \
  (ExpandDArray(darray), (TRUE)) : (TRUE)))
     
#define GetDArraySize(darray) \
((unsigned long)((darray)->curr_ditem - (&(darray)->ditems[0])))

#define GetDArrayItem(darray, index) \
((darray)->ditems[(index)])

#define ClearDArray(darray) \
((darray)->curr_ditem = (&(darray)->ditems[0]))


#define RemDArrayItem(darray, index) \
((darray)->curr_ditem--, \
  ((darray)->ditems[(index)] = (*(darray)->curr_ditem)))


DARRAY *CreateDArray(void);
void DeleteDArray(DARRAY *darray);

void SortDArray(DARRAY *darray);

/* For internal use only! */

void ExpandDArray(DARRAY *darray);

#endif /* DARRAY_H */
