// Copyright 1998,1999,2000 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

////////////////////////////////////////////////////////////////////////
//
// Thanks to Burkhard for permission to use his code.
//
// This C++ code is based on the following C file:
// (See subdirectory mci)
//
////////////////////////////////////////////////////////////////////////

/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* tree.c                    */
/* Burkhard Graves, 26.10.94 */
/*****************************/

#include <stdlib.h>
#include "tree.h"
#include "y_tab.h"
#include "main.h"
#include "ptnet.h"

/**************************************************************************/
/* Erzeugung eines Syntaxbaum-Knotens.                                    */
/**************************************************************************/

TreeNode *TreeCreateNode(int info,TreeNode *left,TreeNode *right,
			 unsigned long place_num)
{
    TreeNode *node;

    (node=(TreeNode *)malloc(sizeof(TreeNode)))->info = info;
    node->left = left;
    node->right = right;
    node->place_num = place_num;

    return node;
}

/**************************************************************************/
/* Duplizieren des Syntaxbaumes.                                          */
/**************************************************************************/

TreeNode *TreeCopy(TreeNode *node)
{
    if (node)
        return TreeCreateNode(node->info,
                              (node->info != PLACE) ?
                              TreeCopy(node->left) : node->left,
                              (node->info != PLACE) ?
                              TreeCopy(node->right) : node->right,
			      node->place_num);
    else
        return NULL;
}

/**************************************************************************/
/* Loeschen des Syntaxbaumes.                                             */
/**************************************************************************/

void TreeDelete(TreeNode *node)
{
    if (node) {
        if (node->info!=PLACE) {
            TreeDelete(node->left);
            TreeDelete(node->right);
        }
        free(node);
    }
}

/**************************************************************************/
/* Ausgabe des Syntaxbaumes.                                              */
/**************************************************************************/

void TreeDisplay(FILE *out,TreeNode *node)
{
    char *ptr=NULL;

    if (node) {
        switch (node->info) {
        case PLACE:
            fprintf(out,net_for_parser->getPlName(node->place_num));
            break;
        default:
            fputc('(',out);
            TreeDisplay(out,node->left);
            switch (node->info) {
            case RELEASE:   ptr=" R ";     break;
            case UNTIL:     ptr=" U ";     break;
            case BOX:       ptr="G ";       break;
            case DIAMOND:   ptr="F ";       break;
            case IMPL:      ptr=" => ";     break;
            case OR:        ptr=" or ";     break;
            case AND:       ptr=" and ";    break;
            case NOT:       ptr="not ";     break;
            default:
                fprintf(stderr, "TreeDisplay(): default ?\n");
		exit(1);
                break;
            }
            fprintf(out,ptr);
            TreeDisplay(out,node->right);
            fputc(')',out);
        }
    }
}

/**********************/
/* END OF FILE tree.c */
/**********************/
