/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* main.c                    */
/* Burkhard Graves, 08.09.97 */
/*****************************/

#include <time.h>
#include <ctype.h>
#include <string.h>
#include <sys/stat.h>

#include "normal.h"
#include "mca.h"
#include "y_tab.h"

/* fuer altes SUNOS: */

#ifndef CLOCKS_PER_SEC
#define CLOCKS_PER_SEC 1000000L
#define OLD_SUNOS
#endif

/********************/
/* Globale Variable */
/********************/

FILE *yyin,*yyout;  /* Zu allgemeinen Ein/Ausgabe-Zwecken */
char *path_file;    /* File zur Ausgabe von Pfaden        */
 int flags;         /* Diverse Flags.                     */
                    /* (extern)                           */

char *net_file;     /* Filenamen */
char *formula_file;
char *solution_file;
char *iso_file;

clock_t ttime;      /* zur Zeitmessung */

extern YYSTYPE yyval;

/*******************************/
/* Prototyp des (yacc-)Parsers */
/*******************************/

int yyparse PROTO ((void));

/************************/
/* Speicher reservieren */
/************************/

void *MyMalloc(size_t size)
{
    void *m;

    if ((m=malloc(size))==NULL)
        Fatal("Speicheranforderung abgewiesen !");
    return m;
}

/***************************/
/* Speichergroesse aendern */
/***************************/

void *MyRealloc(void *ptr,size_t size)
{
    void *r;

    if ((r=realloc(ptr,size))==NULL)
        Fatal("Speicheranforderung abgewiesen !");
    return r;
}

/******************/
/* Fataler Fehler */
/******************/

void Fatal(char *msg)
{
    fprintf(stderr,"\n%s\nProgrammabbruch !\n",msg);
    exit(1);
}

/************************/
/* Aufruf demonstrieren */
/************************/

static void usage(char *myname)
{
    fprintf(stderr,"\nUsage: %s net_file [-cm] ",myname);
    fprintf(stderr,"[-f=fname] [-i=fname] [-s=fname] [-p=fname]\n\n");
    fprintf(stderr,"c: force calculation of informations\n");
    fprintf(stderr,"m: write only minimal firing-sequences\n");
    fprintf(stderr,"f: specify formula-file\n");
    fprintf(stderr,"i: specify iso-file\n");
    fprintf(stderr,"s: specify solution-file\n");
    fprintf(stderr,"p: specify firing-sequences-file\n");
    fprintf(stderr,"\n                         Idea: "
                   "Javier Esparza ('93)\n");
    fprintf(stderr,"Implementation & Improvements: "
                   "Burkhard Graves ('94...'97)\n");
    fprintf(stderr,"                      Version: 4.3\n");
    fprintf(stderr,"          Date of compilation: %s\n\n",__DATE__);
    exit(1);
}

/******************/
/* Namen einlesen */
/******************/

static void read_name(char *ptr1,char **ptr2,char *myname)
{
    if (*++ptr1=='=' && *++ptr1)
        *ptr2=ptr1;
    else
        usage(myname);
}

/******************/
/* Flags einlesen */
/******************/

static void read_flags(char *ptr,char *myname)
{
    while (*++ptr) {
        switch(*ptr) {
        case 'l':
            flags|=LTL;
            break;
        case 'c':
            flags|=CALC_INFO;
            break;
        case 'm':
            flags|=MIN_PATH;
            break;
        case 'f':
            read_name(ptr,&formula_file,myname);
            return;
        case 'i':
            read_name(ptr,&iso_file,myname);
            return;
        case 's':
            read_name(ptr,&solution_file,myname);
            return;
        case 'p':
            read_name(ptr,&path_file,myname);
            return;
        case 'r':
            flags|=SHOW_REL;
            break;
        case 'w':
            yyout=NULL;
            break;
        default:
            usage(myname);
        }
    }
}

/****************/
/* File oeffnen */
/****************/

FILE *OpenFile(char *fname,char *mode)
{
    FILE *f;

    if ((f=fopen(fname,mode))==NULL) {
        fprintf(stderr,"Datei %s kann nicht geoeffnet werden !\n",fname);
        exit(1);
    }
    printf("%c: %s\n",*mode,fname);
    return f;
}

/*****************/
/* Hauptprogramm */
/*****************/

int main(int argc,char *argv[])
{
    int i;

    InitMaske();    /* Initialisierung und Test der Mengendarstellung */

    net_file=formula_file=solution_file=path_file=iso_file=NULL;
    yyout=stdout;
    flags=0;        /* Alle Flags loeschen */

    for (i=1; i<argc; ++i)
        if (*(argv[i])!='-')
            if (!net_file)
                net_file=argv[i];
            else
                usage(argv[0]);
        else
            read_flags(argv[i],argv[0]);
    if (!net_file)
        usage(argv[0]);

    if (!yyout)
        yyout=OpenFile("mca.out","w");

    yyin=OpenFile(net_file,"r");

    ttime=clock();
    ReadMciFile(yyin);
    fclose(yyin);

    printf("\nGoodbye !\n\n");
    return 0;
}

/**********************/
/* END OF FILE main.c */
/**********************/
