/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* normal.c                  */
/* Burkhard Graves, 26.10.94 */
/*****************************/

#include "normal.h"
#include "y_tab.h"

/**************************************************************************/
/* Lokale Umformung.                                                      */
/**************************************************************************/

static int lokal_umf(TreeNode *node)
{
    int _left,_right;
    TreeNode *mem;

    switch (node->info) {
    case NOT:
        if ((_right=node->right->info)==NOT) {
            *node=*((mem=node->right)->right);
            MyFree(mem->right);
            MyFree(mem);
            return 1;
        } else if (_right==OR || _right==AND) {
            node->info=(_right==OR)?AND:OR;
            node->left=TreeCreateNode(node->right->info=NOT
                                      ,NULL,node->right->left);
            node->right->left=NULL;
            return 1;
        } else if (_right==TRUE || _right==FALSE) {
            node->info=(_right==TRUE)?FALSE:TRUE;
            MyFree(node->right);
            node->right=NULL;
            return 1;
        }
        return 0;
    case AND:
        if ((_left=node->left->info)==OR) {
            node->info=OR;
            node->right=TreeCreateNode(AND,node->left->right,mem=node->right);
            node->left->info=AND;
            node->left->right=TreeCopy(mem);
            return 1;
        } else if ((_right=node->right->info)==OR) {
            node->info=OR;
            node->left=TreeCreateNode(AND,mem=node->left,node->right->left);
            node->right->info=AND;
            node->right->left=TreeCopy(mem);
            return 1;
        } else if (_left==FALSE || _right==FALSE) {
            node->info=FALSE;
            TreeDelete(node->left);
            TreeDelete(node->right);
            node->left=node->right=NULL;
            return 1;
        } else if (_left==TRUE) {
            MyFree(node->left);
            *node=*((mem=node->right));
            MyFree(mem);
            return 1;
        } else if (_right==TRUE) {
            MyFree(node->right);
            *node=*((mem=node->left));
            MyFree(mem);
            return 1;
        }
        return 0;
    case OR:
        if ((_left=node->left->info)==FALSE) {
            MyFree(node->left);
            *node=*((mem=node->right));
            MyFree(mem);
            return 1;
        } else if ((_right=node->right->info)==FALSE) {
            MyFree(node->right);
            *node=*((mem=node->left));
            MyFree(mem);
            return 1;
        } else if (_left==TRUE || _right==TRUE) {
            node->info=TRUE;
            TreeDelete(node->left);
            TreeDelete(node->right);
            node->left=node->right=NULL;
            return 1;
        }
        return 0;
    case DIAMOND:
        if ((_right=node->right->info)==DIAMOND) {
            node->right=(mem=node->right)->right;
            MyFree(mem);
            return 1;
        } else if (_right==OR) {
            node->info=OR;
            node->left=TreeCreateNode(node->right->info=DIAMOND
                                      ,NULL,node->right->left);
            node->right->left=NULL;
            return 1;
        } else if (_right==TRUE || _right==FALSE) {
            node->info=_right;
            MyFree(node->right);
            node->right=NULL;
            return 1;
        }
        return 0;
    case EXISTS:
        if ((_right=node->right->info)==OR) {
            node->info=OR;
            node->left=TreeCreateNode(node->right->info=EXISTS
                                      ,NULL,node->right->left);
            node->right->left=NULL;
            return 1;
        } else if (_right==TRUE || _right==FALSE) {
            node->info=_right;
            MyFree(node->right);
            node->right=NULL;
            return 1;
        }
        return 0;
    default:
        return 0;
    }
}

/**************************************************************************/
/* Globale Umformung.                                                     */
/**************************************************************************/

int Normalform(TreeNode *node)
{
    int changed;

    if (node) {
        changed=0;
        for (;;) {
            while (lokal_umf(node))
                changed=1;
            if (node->info!=PLACE
                && Normalform(node->left)+Normalform(node->right))
                if (lokal_umf(node))
                    changed=1;
                else
                    break;
            else
                break;
        }
        return changed;
    } else
        return 0;
}

/************************/
/* END OF FILE normal.c */
/************************/
