/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* main.h                    */
/* Burkhard Graves, 26.10.94 */
/*****************************/

#ifndef __MAIN_H__
#define __MAIN_H__

/**********************************/
/* 1 ~> mit Speicher-Ueberwachung */
/**********************************/

#if 0
#define MEMORY
#endif

/*************************/
/* 1 ~> check assertions */
/*************************/

#if 0
#undef NDEBUG
#else
#define NDEBUG
#endif

/******************************/
/* 1 ~> mit diversen Ausgaben */
/******************************/

#if 0
#define OUTPUT
#endif

/*********************/
/* Prototypen an/aus */
/*********************/

#if 1
#define PROTO(x) x
#else
#define PROTO(x) ()
#endif

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

/****************************/
/* Externe globale Variable */
/****************************/

extern FILE *yyin,*yyout;
extern char *path_file;
extern  int flags;

/* Makros fuer 'flags' */

#define CALC_INFO 1
#define V2        2
#define SHOW_REL  4
#define MIN_PATH  8
#define LTL      16

/**************/
/* Prototypen */
/**************/

FILE  *OpenFile PROTO ((char *fname,char *mode));
void      Fatal PROTO ((char *msg));
void  *MyMalloc PROTO ((size_t size));
void *MyRealloc PROTO ((void *ptr, size_t size));
void      Check PROTO ((void (*read)(FILE *)
                        ,void (*calc)(void),void (*save)(FILE *)));

#ifdef MEMORY

void     MyFree PROTO ((void *pointer));

#else

#define MyFree(pointer) free((void *)(pointer));

#endif

#endif

/**********************/
/* END OF FILE main.h */
/**********************/
