// Copyright 2000 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#ifndef MONSET_H
#define MONSET_H

#include "combi.h"
#include "bitarr.h"

typedef unsigned long MONSET_ITEM;

typedef struct monset
{
  BITARRAY *monsetbits;       /* MonSet membership bits */
  MONSET_ITEM *curr_monsitem;
  MONSET_ITEM monsitems[1];
} MONSET;


#define AddtoMonSet(monset, item) \
(GetBit((monset)->monsetbits, (item)) ? \
 (TRUE) : \
 (SetBit((monset)->monsetbits, (item)), \
  *(monset)->curr_monsitem++ = (item), \
  (FALSE)))

#define EmptyMonSet(monset) \
(((monset)->curr_monsitem == (&(monset)->monsitems[0])) ? \
 (TRUE) : (FALSE))

#define GetMonSetSize(monset) \
((unsigned long)((monset)->curr_monsitem - (&(monset)->monsitems[0])))

#define GetMonSetItem(monset, index) \
((monset)->monsitems[(index)])

#define InMonSet(monset, item) \
(GetBit((monset)->monsetbits, (item)))


MONSET *CreateMonSet(unsigned long domainsize);
void DeleteMonSet(MONSET *monset);

void ClearMonSet(MONSET *monset);
MONSET *CopyMonSet(MONSET *src);
void SortMonSet(MONSET *monset);

#define DEBUG_MONSET
#ifdef DEBUG_MONSET

void PrintMonSet(MONSET *monset);

#endif


#endif /* MONSET_H */
