#!/usr/bin/env zsh
setopt extendedglob
help_text="Usage: $0 --logdir <logdir>

Other options:
-h, --help:           show this help
--timelimit <n>:      time limit for a single run in seconds (default 120)
--memlimit <n>:       memory limit for a single run in MB (default 512)"

fail () {
	print -u 2 -- "$1"
	exit 1
}

zparseopts -D -E -a help -- -logdir:=logdir -timelimit:=timelimit -memlimit:=memlimit -help h

if [[ -n $help ]]; then
	print -- $help_text
	exit 0
fi

[[ -z $logdir ]] && fail "You must specify --logdir"
logdir=$logdir[2]
[[ -e $logdir ]] && fail "$logdir exists!"
mkdir -p $logdir || fail "Could not make new directory $logdir"

timelimit=${timelimit[2]:-120}
memlimit=${memlimit[2]:-512}
memlimit=$((memlimit*1024))

pushd ${0:h}/..
top=$PWD
popd

for pair in $top/implementations/*; do
	for implementation in $pair/*; do
		for testset in $top/tests/*; do
			for test in $testset/**/*(.); do
				rundir=$logdir/${testset:t}-${pair:t}/${implementation:t}/${test:t}
				mkdir -p $rundir || fail "Could not make directory $rundir"
				cp $test $rundir/model.smv || fail "Could not copy model to $rundir"
				pushd $rundir
				/usr/bin/time -p zsh -c "ulimit -t $timelimit -v $memlimit ; \"$implementation\" model.smv > out.log 2> err.log ; print \$? > exitstatus" 2> time
				popd
			done
		done
	done
done
