/*
 This file is part of the PSL Observer modification for NuSMV.
 Copyright (C) 2008-2009 Tuomas Launiainen.
 
 This program is free software; you can redistribute it and/or 
 modify it under the terms of the GNU Lesser General Public 
 License as published by the Free Software Foundation; either 
 version 2 of the License, or (at your option) any later version.
 
 This program is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of 
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public 
 License along with this library; if not, write to the Free Software 
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
 
 For more information, see <http://www.tcs.hut.fi/~tlauniai/psl-observer>.
 */ 
#ifndef __FSM_H__
#define __FSM_H__

#include "node/node.h"

typedef struct fsm* fsm;

fsm make_fsm();
void free_fsm(fsm);
char* sprint_fsm(fsm);
boolean fsm_is_accepting(fsm a, node_ptr s);
void fsm_add_accepting(fsm a, node_ptr s);  
node_ptr fsm_list_accepting(fsm a);
node_ptr fsm_initial(fsm a);
void fsm_add_edge(fsm a,node_ptr from,node_ptr lbl,node_ptr to);
node_ptr fsm_edges_from(fsm a, node_ptr from);
void fsm_copy_edges(fsm a, fsm from);
void fsm_copy_accepting(fsm a, fsm from);
node_ptr edge_from(node_ptr e);
node_ptr edge_label(node_ptr e);
node_ptr edge_to(node_ptr e);
node_ptr fsm_states(fsm a);
void remove_nil_edges(fsm);
void print_fsm(FILE*,fsm);
fsm fsm_from_sere(node_ptr sere);

#endif
