// Nodes, arcs, Petri net containers, and basic access to a net (enabling, firing,...)

/*
 * This file has been modified by Tommi Junttila by adding
 * the class members starting with the prefix "TJ_"
 */

#ifndef NET_H
#define NET_H

class Node;

#include<streambuf.h>
#include<stream.h>
#include "dimensions.H"
#include "TJ_partition.H"

#define bool int
#define false 0
#define true 1

class Arc;

class formula;
class overflow {};

class Node 
{
 public:
  unsigned int nr;
  char * name; 
  unsigned short int NrOfArriving;
  unsigned short int NrOfLeaving;
  Arc ** ArrivingArcs;
  Arc ** LeavingArcs;
  Node(char *);
  ostream& operator << (ostream &);
  ~Node();
  void NewArriving(Arc&);
  void NewLeaving(Arc&);
  unsigned int pos[2]; // index in array of all nodes, two values for appearance in two arrays
#if defined(SYMMETRY) && (SYMMINTEGRATION == 7)
  unsigned int TJ_ival;
  CellEntry *TJ_in_cell;
#endif
};

inline void Node::NewArriving(Arc & a)
{
  Arc ** Old = ArrivingArcs;
  NrOfArriving++;
  ArrivingArcs = new Arc* [NrOfArriving];
  for(int i = 0; i < NrOfArriving -1;i++)
  {
    ArrivingArcs[i] = Old[i];
  }
  ArrivingArcs[NrOfArriving -1] = & a;
  delete [] Old;
}

inline void Node::NewLeaving(Arc & a)
{
  Arc ** Old = LeavingArcs;
  NrOfLeaving++;
  LeavingArcs = new Arc* [NrOfLeaving];
  for(int i = 0; i < NrOfLeaving -1;i++)
  {
    LeavingArcs[i] = Old[i];
  }
  LeavingArcs[NrOfLeaving -1] = & a;
  delete [] Old;
}

inline Node::~Node()
{
  delete [] name;
  delete []  ArrivingArcs;
  delete [] LeavingArcs;
}

inline Node::Node(char * n)
{
  name = new char [strlen(n) + 1];
  strcpy(name,n);
  NrOfArriving = NrOfLeaving = 0;
  ArrivingArcs = new Arc* [1];
  LeavingArcs = new Arc*  [1];
}

extern unsigned int currentdfsnum;
// contains dfsnum of currently processed state, used for
//  ignorance managment
#ifdef MODELCHECKING
extern unsigned int formulaindex; // in modelchecking,
//the different subformulas must be treated spearately 
#endif

inline ostream& operator << (ostream & str,Node n)
{
  str << n.name;
  return str;
}
  
class Transition;

class Place: public Node
{
 public:
  static unsigned int cnt; // Number of places for statistics;
  Place(char *);
  ~Place();
  static unsigned int hash_value;
  unsigned int target_marking;
  unsigned int initial_marking;
  unsigned int current_marking;
  unsigned int hash_factor;
  void operator += (unsigned int);  // increment marking of place
  void operator -= (unsigned int);  // decrement marking of place
  bool operator >= (unsigned int);  // test enabledness with respect to place
  void set_marking(unsigned int);   // set marking of place;
  void set_hash(unsigned int);      // define a factor for hash value calculation
  // hash(m) = sum(p in P) p.hash_factor*p.current_marking
  unsigned int index; // index in place array, necessary for symmetries
  unsigned int references; // we remove isolated places 
#ifdef STUBBORN
  unsigned int visible; // number of visible pre-transitions
  Transition ** PreTransitions; // List of pre-transitions (used as "mustbeincluded")
  Transition ** PostTransitions; // List of post-transitions (used as "mustbeincluded")
  void initialize();
#endif
#ifdef COVER
	bool bounded; // true if marking in current state is not omega
	unsigned int lastfinite; // number of tokens in the moment of omega-intro
#endif
#ifdef WITHFORMULA
	unsigned int cardprop; // number of propositions mentioning this pl.
	formula ** propositions;
#endif
};


inline Place::Place(char * name) : Node(name)
{
  cnt += 1;
  if(!(cnt % REPORTFREQUENCY))
  {
	cerr << "\n" << cnt << "places parsed\n";
  }
  references = initial_marking = current_marking = target_marking = hash_factor = 0;
#ifdef COVER
	bounded = true;
#endif
#ifdef STUBBORN
	visible = 0; // real setting in sortscapegoats()
#endif
#ifdef WITHFORMULA
	cardprop = 0;
#endif
}


inline Place::~Place()
{
  cnt -= 1;
}
  
inline void Place::operator += (unsigned int i)
{
  current_marking += i;
  hash_value += i*hash_factor;
  hash_value %= HASHSIZE;
}

inline void Place::operator -= (unsigned int i)
{
  current_marking -= i;
  hash_value -= i*hash_factor;
  hash_value %= HASHSIZE;
}

inline bool Place::operator >= (unsigned int i)
{
  return((current_marking >= i) ? 1 : 0);
}

inline void Place::set_hash(unsigned int i)
{
  hash_value -= hash_factor * current_marking;
  hash_factor = i;
  hash_value += hash_factor * current_marking;
  hash_value %= HASHSIZE;
}
  
inline void Place::set_marking(unsigned int i)
{
  hash_value -= hash_factor * current_marking;
  current_marking = i;
  hash_value += hash_factor * current_marking;
  hash_value %= HASHSIZE;
}  


class Arc
{
 public:
	static unsigned int cnt;
  Node * Source;
  Node * Destination;
  Place * pl;
  Transition * tr;
  unsigned int Multiplicity;
  Arc(Transition *, Place *, bool ,unsigned int);
  Node * Get(bool);
  void operator += (unsigned int);
};

#ifdef STUBBORN
inline void Place::initialize()
{
	int i;
	
  // Create list of pre-transitions. If this place is the scapegoat for a disabled transition in
  // stubborn set then these transitions must be in the stubborn set, too.
  PreTransitions = new Transition * [NrOfArriving+1];
  PostTransitions = new Transition * [NrOfLeaving+1];
  for(i=0;i < NrOfArriving;i++)
    {
	PreTransitions[i] = ArrivingArcs[i]-> tr;
    }
    PreTransitions[NrOfArriving] = (Transition *) 0;
  for(i=0;i < NrOfLeaving;i++)
    {
	PostTransitions[i] = LeavingArcs[i]-> tr;
    }
    PostTransitions[NrOfLeaving] = (Transition *) 0;
}
#endif

inline Arc::Arc(Transition * t,Place * p, bool totrans, unsigned int mult)
{
  tr = t;
  pl = p;
  Source = totrans ? (Node *) p : (Node *) t;
  Destination = totrans ? (Node *) t : (Node *) p;
  Multiplicity = mult;
	cnt++;
}

inline Node * Arc::Get(bool dest)
{
  return dest? Destination : Source;
}

inline void Arc::operator += (unsigned int incr)
{
  Multiplicity += incr;
}

class Transition:public Node
{
 public:
  static unsigned int cnt; // statistics;
  static Transition * StartOfEnabledList;
  Transition(char *);
  ~Transition();
  static unsigned int NrEnabled; // Number of enabled tr. at curr. state
  bool enabled;
  Transition * NextEnabled;
  Transition * PrevEnabled; // double linking in list of enabled transitions
  // in the sequel, lists are NIL-terminated
  Place ** PrePlaces; // Places to be checked for enabledness
  unsigned int * Pre; // Multiplicity to be checked
  Place ** IncrPlaces; // Places that are incremented by transition
  unsigned int * Incr; // Amount of increment
  Place ** DecrPlaces; // Places that are decremented by transition
  unsigned int * Decr; // amount of decrement
  Transition ** ImproveEnabling; // list of transitions where enabledness
  //must be checked again after firing this transition
  Transition ** ImproveDisabling; // list of transitions where disabledness
  // must be checked again after firing this transition
  void initialize(); // Set above arrays, list, enabled...
  void fire(); // replace current marking by successor marking, force
  // enabling test where necessary
  void backfire(); // fire transition backwards to replace original state,
  // force enabling tests where necessary
  inline void check_enabled(); // test if tr is enabled. If necessary, rearrange list
	int hash_change; // change of hash value by firing t;
	void set_hashchange();
#ifdef STUBBORN
  static Transition * StartOfStubbornList;
  static Transition * EndOfStubbornList;
  static unsigned int NrStubborn; // Nr. of enabled (!) transitions in stubborn set
  Transition * NextStubborn;
  unsigned int instubborn;
  Place * scapegoat; // unsufficiently marked place for disabled transition
  Transition ** mustbeincluded; // If this transition is in a stubborn set, these ones must be, too
  Transition ** conflicting; // Transitions that can disable this transition
  unsigned int dfs; 
  unsigned int min; 
  unsigned int stamp;
  unsigned int mbiindex; // index in must be included list;
  Transition * nextontarjanstack; // for tscc based stubborn set method
  Transition * nextoncallstack; // for tscc based stubborn set method
  static Transition * TarjanStack;
  static Transition * CallStack;
  bool visible;
#endif 
#ifdef MODELCHECKING
	unsigned int * lstdisabled;
	unsigned int * lstfired;
#else
	bool down; // transition is in the down set of a state predicate
	unsigned int lastdisabled; // dfsnum of last state where
							  // some fired transition disables this one
	unsigned int lastfired; // dfsnum of last state where this tr. was fired
	Transition ** add_up; // addditional transitions to be included when
						  // this transition is in down set
#endif
  static Transition * StartOfIgnoredList; // which transitions could be
  Transition * NextIgnored;               //potentially ignored
#ifdef WITHFORMULA
	bool * pathrestriction;
#endif
};

inline Transition::Transition(char * name):Node(name)
{
  cnt += 1;
  if(!(cnt % REPORTFREQUENCY))
  {
	cerr << "\n" << cnt << "transitions parsed\n";
  }
  enabled = false;
#ifdef STUBBORN
  stamp = 0;
  NextStubborn = (Transition *) 0;
  instubborn = false; 
  visible = false;
#endif
#ifdef EXTENDED
#ifndef MODELCHECKING
  lastfired = lastdisabled = 0;
  down = false;
  add_up = (Transition ** ) 0;
#endif
#endif
}

inline void Transition::set_hashchange()
{
	unsigned int i;

	hash_change = 0;
	for(i=0;IncrPlaces[i];i++)
	{
		hash_change += Incr[i] * IncrPlaces[i]->hash_factor;
	}
	for(i=0;DecrPlaces[i];i++)
	{
		hash_change -= Decr[i] * DecrPlaces[i]->hash_factor;
	}
	hash_change %= HASHSIZE;
}


inline Transition::~Transition()
{
  cnt -= 1;
}

inline void Transition::initialize()
{
  unsigned int i,j,k;

  // Create list of Pre-Places for enabling test
  PrePlaces = new Place *  [NrOfArriving + 1];
  Pre = new unsigned int [NrOfArriving + 1];
  for(i = 0; i < NrOfArriving;i++)
    {
      PrePlaces[i] = ArrivingArcs[i]->pl;
      Pre[i] = ArrivingArcs[i]->Multiplicity;
    }
  PrePlaces[NrOfArriving] = (Place *) 0;
  // Create list of places where transition increments marking
  IncrPlaces = new Place * [NrOfLeaving + 1];
  Incr = new unsigned int [NrOfLeaving + 1];
  
  k=0;
  for(i = 0; i < NrOfLeaving;i++)
    {
      //Is Place a loop place?
      for(j=0;j<NrOfArriving;j++)
	{
	  if((LeavingArcs[i]->Destination) == (ArrivingArcs[j]->Source))
	    {
	      break;
	    }
	}
      if(j<NrOfArriving)
	{
	  //yes, loop place
	  if(LeavingArcs[i]->Multiplicity > ArrivingArcs[j]->Multiplicity)
	    {
	      // indeed, transition increments place
	      IncrPlaces[k] = LeavingArcs[i]->pl;
	      Incr[k] = LeavingArcs[i]->Multiplicity - ArrivingArcs[j]->Multiplicity;
	      k++;
	    } 
	}
      else
	{
	  // no loop place
	  IncrPlaces[k] = LeavingArcs[i]->pl;
	  Incr[k] = LeavingArcs[i]->Multiplicity;
	  k++;
	}
    }
  IncrPlaces[k] = (Place *) 0;
  // Create list of places where transition decrements marking
  DecrPlaces = new Place * [NrOfArriving + 1];
  Decr = new unsigned int [NrOfArriving + 1];
  k=0;
  for(i = 0; i < NrOfArriving;i++)
    {
      //Is Place a loop place?
      for(j=0;j<NrOfLeaving;j++)
	{
	  if((ArrivingArcs[i]->Source) == (LeavingArcs[j]->Destination))
	    {
	      break;
	    }
	}
      if(j<NrOfLeaving)
	{
	  //yes, loop place
	  if(ArrivingArcs[i]->Multiplicity > LeavingArcs[j]->Multiplicity)
	    {
	      // indeed, transition decrements place
	      DecrPlaces[k] = ArrivingArcs[i]->pl;
	      Decr[k] = ArrivingArcs[i]->Multiplicity - LeavingArcs[j]->Multiplicity;
	      k++;
	    } 
	}
      else
	{
	  // no loop place
	  DecrPlaces[k] = ArrivingArcs[i]->pl;
	  Decr[k] = ArrivingArcs[i]->Multiplicity;
	  k++;
	}
    }
  DecrPlaces[k] = (Place *) 0;
  // Create list of transitions where enabledness can change
  // if this transition fires. For collecting these transitions, we
  // abuse the Enabled linked list
  StartOfEnabledList = (Transition *) 0;
  NrEnabled = 0;
  for(i=0;IncrPlaces[i];i++)
    {
      for(j=0;j<IncrPlaces[i]->NrOfLeaving;j++)
	{
	  if(!(IncrPlaces[i]->LeavingArcs)[j]->tr->enabled)
	    {
	      // not yet in list
	      (IncrPlaces[i]->LeavingArcs)[j]->tr->NextEnabled = StartOfEnabledList;
	      StartOfEnabledList = (IncrPlaces[i]->LeavingArcs)[j]->tr;
	      NrEnabled++;
	      (IncrPlaces[i]->LeavingArcs)[j]->tr->enabled = true;
	    }
	}
    }
  ImproveEnabling = new Transition * [NrEnabled + 1];
  for(i=0;StartOfEnabledList;StartOfEnabledList = StartOfEnabledList -> NextEnabled,i++)
    {
      StartOfEnabledList->enabled = false;
      ImproveEnabling[i]=StartOfEnabledList;
    }
  ImproveEnabling[i] = (Transition *) 0;
  // Create list of transitions where enabledness can change
  // if this transition fires. For collecting these transitions, we
  // abuse the Enabled linked list
  StartOfEnabledList = (Transition *) 0;
  NrEnabled = 0;
  for(i=0;DecrPlaces[i];i++)
    {
      for(j=0;j<DecrPlaces[i]->NrOfLeaving;j++)
	{
	  if(!(DecrPlaces[i]->LeavingArcs)[j]->tr->enabled)
	    {
	      // not yet in list
	      (DecrPlaces[i]->LeavingArcs)[j]->tr->NextEnabled = StartOfEnabledList;
	      StartOfEnabledList = (DecrPlaces[i]->LeavingArcs)[j]->tr;
	      NrEnabled++;
	      (DecrPlaces[i]->LeavingArcs)[j]->tr->enabled = true;
	    }
	}
    }
  ImproveDisabling = new Transition * [NrEnabled + 1];
  for(i=0;StartOfEnabledList;StartOfEnabledList = StartOfEnabledList -> NextEnabled,i++)
    {
      StartOfEnabledList->enabled = false;
      ImproveDisabling[i]=StartOfEnabledList;
    }
  ImproveDisabling[i] = (Transition *) 0;
#ifdef STUBBORN
  // Create list of conflicting transitions. If this  transition is enabled nd member of a
  // stubborn set then these transitions must be in the stubborn set, too.
  StartOfEnabledList = (Transition *) 0;
  NrEnabled = 0;
  for(i=0;PrePlaces[i];i++)
    {
      for(j=0;j<PrePlaces[i]->NrOfLeaving;j++)
	{
	 if(!((PrePlaces[i]->LeavingArcs)[j]->tr == this))
	 {
	  if(!(PrePlaces[i]->LeavingArcs)[j]->tr->enabled)
	    {
	      // not yet in list
	      (PrePlaces[i]->LeavingArcs)[j]->tr->NextEnabled = StartOfEnabledList;
	      StartOfEnabledList = (PrePlaces[i]->LeavingArcs)[j]->tr;
	      NrEnabled++;
	      (PrePlaces[i]->LeavingArcs)[j]->tr->enabled = true;
	    }
	 }
	}
    }
  conflicting = new Transition * [NrEnabled + 1];
  for(i=0;StartOfEnabledList;StartOfEnabledList = StartOfEnabledList -> NextEnabled,i++)
    {
      StartOfEnabledList->enabled = false;
      conflicting[i]=StartOfEnabledList;
    }
  conflicting[i] = (Transition *) 0;
#endif
  NrEnabled = 0;
  NextEnabled = PrevEnabled = StartOfEnabledList = (Transition *) 0;
}


inline void Transition::fire()
{
  Place ** p;
  Transition ** t;
  unsigned int * i;

#ifdef EXTENDED
#ifdef MODELCHECKING
	lstfired[formulaindex] = currentdfsnum;
#else
	lastfired = currentdfsnum;
#endif
#endif
  for(p = IncrPlaces,i = Incr; *p; p++,i++)
    {
#ifdef COVER
if((*p)-> bounded)
#endif
      ** p += * i;
    }
  for(p = DecrPlaces,i = Decr; * p; p++,i++)
    {
#ifdef COVER
if((*p)-> bounded)
#endif
      ** p -= * i;
    }

  for(t = ImproveEnabling;*t;t++)
    {
      if(!((*t) -> enabled))
	{
	  (*t)->check_enabled();
	}
    }
  for(t = ImproveDisabling;*t;t++)
    {
      if((*t)->enabled)
	{
	  (*t)->check_enabled();
	}
    }
}

inline void Transition::backfire()
{
  Place ** p;
  Transition ** t;
  unsigned int * i;

  for(p = IncrPlaces,i = Incr; *p; p++,i++)
    {
#ifdef COVER
	  if((*p)->bounded)
#endif
      ** p -= * i;
    }
  for(p = DecrPlaces,i = Decr; * p; p++,i++)
    {
#ifdef COVER
	  if((*p)->bounded)
#endif
      ** p += * i;
    }
  for(t = ImproveEnabling;*t;t++)
    {
      if((*t) -> enabled)
	{
	  (*t)->check_enabled();
	}
    }
  for(t = ImproveDisabling;*t;t++)
    {
      if(!((*t)->enabled))
	{
	  (*t)->check_enabled();
	}
    }
}

inline void Transition::check_enabled()  
{
  Place ** p;
  unsigned int *i;

  for(p = PrePlaces , i = Pre ; *p ; p++ , i++)
    {
      if(((*p)->current_marking) < (* i))
	{
	  if(enabled)
	    {
#ifdef EXTENDED
#ifdef MODELCHECKING
		  lstdisabled[formulaindex] = currentdfsnum;
#else
		  lastdisabled = currentdfsnum;
#endif
#endif
	      // exclude transition from list of enabled transitions
	      if(NextEnabled)
		{
		  NextEnabled -> PrevEnabled = PrevEnabled;
		}
	      if(PrevEnabled)
		{
		  PrevEnabled -> NextEnabled = NextEnabled;
		}
	      else
		{
		  StartOfEnabledList = NextEnabled;
		}
	      enabled = false;
	      NrEnabled--;
	    }
#ifdef STUBBORN
	      mustbeincluded = (*p)->PreTransitions;
              scapegoat = *p;
#endif
	  return;
  	}
    }
  if(!enabled)
    {
      // include transition into list of enabled transitions
      NextEnabled = StartOfEnabledList;
      if(StartOfEnabledList)
	{
		NextEnabled -> PrevEnabled = this;
	}
      StartOfEnabledList = this;
      PrevEnabled = (Transition *) 0;
      enabled = true;
      NrEnabled++;
#ifdef STUBBORN
      mustbeincluded = conflicting;
#endif
    }
}

extern Place ** Places;
extern Place * CheckPlace;
extern Transition * CheckTransition;
extern Transition ** Transitions;
extern unsigned int Edges;
extern Transition * LastAttractor; // Last transition in list of
// static attractor set. Attractor sets form always a prefix in the 
// list of stubborn transitions. Static attractor transitions are never
// removed from that list.

// file names for input and output

extern char * netfile;
extern char * analysefile;
extern char * graphfile;
extern char * pathfile;
extern char * statefile;
extern char * symmfile;
extern char * netbasename;

extern bool Aflg, Sflg, Yflg, Pflg,GMflg, aflg, sflg, yflg,pflg,gmflg;
extern char graphformat;


#endif



















