#include <stdlib.h>
#include "TJ_heap.H"

void Heap::upheap(unsigned int k) {
  unsigned int v = array[k];
  array[0] = UINT_MAX;
  while(array[k/2] <= v) {
    array[k] = array[k/2];
    k = k/2;
  }
  array[k] = v;
}

void Heap::downheap(unsigned int k) {
  unsigned int j, v;
  v = array[k];
  while(k <= n/2) {
    j = k + k;
    if(j < n && array[j] < array[j+1])
      j++;
    if(v >= array[j])
      break;
    array[k] = array[j];
    k = j;
  }
  array[k] = v;
}

void Heap::init(unsigned int size) {
  array = (unsigned int*)malloc((size + 1) * sizeof(unsigned int));
  n = 0;
#ifdef TJ_DEBUG
  assert(size > 0);
  N = size;
#endif
}

void Heap::insert(unsigned int v) {
  TJ_DEBUG_ASSERT(n < N);
  array[++n] = v;
  upheap(n);
}

unsigned int Heap::remove() {
  TJ_DEBUG_ASSERT(n >= 1);
  const unsigned int v = array[1];
  array[1] = array[n--];
  downheap(1);
  return v;
}
