#!/usr/bin/perl

$readers=$ARGV[0];
$writers=$ARGV[1];

print "PLACE ";
for($i = 1; $i <= $readers; $i++) {
    print "r",$i,"_idle,r",$i,"_reading,";
}
for($i = 1; $i <= $writers; $i++) {
    print "w",$i,"_idle,w",$i,"_writing,";
}
print "idles;\n";

print "MARKING ";
for($i = 1; $i <= $readers; $i++) {
    print "r",$i,"_idle:1,";
}
for($i = 1; $i <= $writers; $i++) {
    print "w",$i,"_idle:1,";
}
print "idles:",$readers+$writers,";\n";

for($i = 1; $i <= $readers; $i++) {
    print "TRANSITION r",$i,"_enter\n";
    print "CONSUME r",$i,"_idle:1,idles:1;\n";
    print "PRODUCE r",$i,"_reading:1;\n";
    print "\n";
    print "TRANSITION r",$i,"_leave\n";
    print "CONSUME r",$i,"_reading:1;\n";
    print "PRODUCE r",$i,"_idle:1,idles:1;\n";
}

for($i = 1; $i <= $writers; $i++) {
    print "TRANSITION w",$i,"_enter\n";
    print "CONSUME w",$i,"_idle:1,idles:",$readers+$writers,";\n";
    print "PRODUCE w",$i,"_writing:1;\n";
    print "\n";
    print "TRANSITION w",$i,"_leave\n";
    print "CONSUME w",$i,"_writing:1;\n";
    print "PRODUCE w",$i,"_idle:1,idles:",$readers+$writers,";\n";
}
