#include<limits.h>
#include"formula.H"
#include"graph.H"
#include"dimensions.H"
#include<fstream.h>
Decision ** HashTable;
unsigned int LastChoice;
Decision * LastDecision;
unsigned int Scapegoat;
Statevector * LastVector;
unsigned int currentdfsnum = 1;
SearchTrace * Trace;
unsigned int CardFireList;
unsigned int pos;
unsigned int isbounded;
unsigned int State::card = 0;

#define VERYLARGE UINT_MAX

void statistics(unsigned int s, unsigned int e, unsigned int h)
{
	cout << "\n\n>>>>> " << s << " States, " << e << " Edges, " << h << " Hash table entries\n\n";
}

Transition ** firelist()
{
  Transition ** tl;
  Transition * t;
  int i;
  tl = new Transition * [Transitions[0] -> NrEnabled + 1];
  for(i=0,t = Transitions[0]->StartOfEnabledList; t; t = t -> NextEnabled)
    {
#ifdef EXTENDEDCTL
	if(t -> pathrestriction[TemporalIndex])
	{
#endif
      tl[i++] = t;
#ifdef EXTENDEDCTL
	}
#endif
    }
  tl[i] = (Transition *) 0;
  CardFireList = i;
  return tl;
}

void printstate();

Statevector * TSCCRepresentitives;

#ifndef MODELCHECKING

#ifdef STUBBORN
#include"stubborn.H"
#endif
State * SYMMPROC();
unsigned int MinBookmark; // MIN number of the first closed marking
                          // in the currently or last recently processed TSCC
void printpath(State *,ofstream *);
void print_path(State * s)
{
	if(pflg)
	{
		ofstream pathstream(pathfile);
		if(!pathstream)
		{
			cerr << "Cannot open path output file: " << pathfile <<
			"\nno output written\n";
		}
		pathstream << "PATH\n";
		printpath(s,&pathstream);
	}
	if(Pflg)
	{
		cout << "PATH\n";
		printpath(s,(ofstream *) 0);
	}
}
void printpath(State *s,ofstream * pathstream)
{
	// print a path from initial state to s
	if(s -> parent)
	{
		printpath(s -> parent,pathstream);
		if(Pflg)
		{
		cout << s -> parent -> firelist[s -> parent -> current] -> name << "\n";
		}
		if(pflg)
		{
		(*pathstream) << s -> parent -> firelist[s -> parent -> current] -> name << "\n";
		}
	}
}

void printincompletestates(State *s,ofstream * graphstream,int level)
{
	int i,j;
	// level = 1 --> top level, no firelist, mark '!'
	// level = 0 --> other level, firelist,  mark '*'
	if(!s) return;

	if(gmflg)
	{
	  (*graphstream) << "STATE " << (level ? "! " : "* ") << s ->dfs ;
	  j=0;
	  if(graphformat == 'm')
	  {
		 for(i=0;i<Places[0]->cnt;i++)
		 {
			 if(Places[i]->current_marking)
				{
				 if(Places[i]->current_marking == VERYLARGE)
				 {
				 (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo" ;
				 }
				 else
				 {
				 (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
				 }
				 }
		 }

	  }
		 (*graphstream) << "\n\n";
	  if(!level)
	  {
	  for(i=0; i < s -> current;i++)
	  {
		(*graphstream) << s -> firelist[i]->name << " -> " << s -> succ[i]->dfs << "\n";
      }
		(*graphstream) << s -> firelist[s->current]->name << " => " << s -> succ[s->current]->dfs << "\n";
	  for(i = s -> current + 1; s ->firelist[i];i++)
	  {
		(*graphstream) << s -> firelist[i]->name << " -> ?\n";
      }
	  }
	  (*graphstream) << "\n";
	}
	if(GMflg)
	{
	  cout << "STATE " << (level ? "! " : "* ") << s ->dfs;
	  j=0;
	  if(graphformat == 'm')
	  {
		 for(i=0;i<Places[0]->cnt;i++)
		 {
			 if(Places[i]->current_marking)
			 {
				 if(Places[i]->current_marking == VERYLARGE)
				 {

				 cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo";
				 }
				 else
				 {
				 cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
				 }
			 }
		 }

	  }
	  cout << "\n\n";
	  if(!level)
	  {
	  for(i=0; i < s -> current;i++)
	  {
		cout << s -> firelist[i]->name << " -> " <<
		s -> succ[i]->dfs << "\n";
      }
		cout << s -> firelist[s->current]->name << " => " << s -> succ[s->current]->dfs << "\n";
	  for(i = s -> current + 1; s ->firelist[i];i++)
	  {
		cout << s -> firelist[i]->name << " -> ?\n";
      }
	  }
	  cout << "\n";
	}
if(!s->parent) return;
#ifdef COVER
		  if(s -> NewOmega)
		  {
			  // Replace new omegas by their old values
			  for(i=0;s ->NewOmega[i];i++)
			  {
				s ->NewOmega[i]->set_marking(s ->NewOmega[i]->lastfinite);
				s ->NewOmega[i]->bounded = true;
			  }
			  delete [] s ->NewOmega;
		  }
#endif
	s -> parent -> firelist[s -> parent -> current] -> backfire();
	printincompletestates(s -> parent,graphstream,0);
}

#ifdef COVER
void print_reg_path(State *s, State * startofrepeatingseq,ofstream * pathstream,int level)
{
	if(level)
	{
		if(!pflg && ! Pflg) return;
		if(pflg)
		{
			pathstream = new ofstream(pathfile);
			if(!pathstream)
			{
				cerr << "Cannot open path output file: " << pathfile
				<< "\nno output written\n";
				return;
			}
			(*pathstream) << "PATH EXPRESSION \n";
		}
		else
		{
			cout << "PATH EXPRESSION \n";
		}
	}
	// print a regular expression for path  from initial state to 
	// generalised state s in coverability graph
	if(startofrepeatingseq)
	{
		if(s == startofrepeatingseq)
		{
			if(s -> parent)
			{
				int i;
				print_reg_path(s -> parent,s->smaller,pathstream,0);
			if(s->smaller) 
			{
				if(Pflg)
				{
				cout << " ";
				}
				else
				{
				(*pathstream) << " ";
				}
			}
			else
			{
				if(Pflg)
				{
				cout << "\n";
				}
				else
				{
				(*pathstream) << "\n";
				}
			}
				if(Pflg)
				{
				cout << s -> parent -> firelist[s -> parent -> current] -> name;
				}
				else
				{
				(*pathstream) << s -> parent -> firelist[s -> parent -> current] -> name;
				}
			}
			if(s->smaller) 
			{
				if(Pflg)
				{
				cout << " )";
				}
				else
				{
				(*pathstream) << " )";
				}
			}
			if(Pflg)
			{
			cout << "\n(";
			}
			else
			{
			(*pathstream) << "\n(";
			}
		}
		else
		{
			if(s -> parent)
			{
				int i;
				print_reg_path(s -> parent,startofrepeatingseq,pathstream,0);
				if(Pflg)
				{
				cout << " " << s -> parent -> firelist[s->parent->current] -> name ;
				}
				else
				{
				(*pathstream)  << " " << s -> parent -> firelist[s->parent->current] -> name;
				}
			}
			if(s->smaller) 
			{
				if(Pflg)
				{
				cout << " )";
				}
				else
				{
				(*pathstream) << " )";
				}
			}
		}
	}
	else
	{
		if(s -> parent)
		{
			int i;
			print_reg_path(s -> parent,s->smaller,pathstream,0);
			if(s->smaller) 
			{
				if(Pflg)
				{
				cout << " ";
				}
				else
				{
				(*pathstream) << " ";
				}
			}
			else
			{
				if(Pflg)
				{
				cout << "\n";
				}
				else
				{
				(*pathstream) << "\n";
				}
			}
			if(Pflg)
			{
			cout << s -> parent -> firelist[s->parent->current] -> name ;
			}
			else
			{
			(*pathstream) << s -> parent -> firelist[s->parent->current] -> name ;
			}
				
		}
		if(s->smaller) 
		{
			if(Pflg)
			{
			cout << " )";
			}
			else
			{
			(*pathstream) << " )";
			}
		}
	}
}
#endif
		

#define MIN(X,Y) ( (X) < (Y) ? (X) : (Y)) 

State * CurrentState;

unsigned int depth_first()
{
  ofstream * graphstream;
  unsigned int i;
  unsigned int NumberOfStates;
  State * NewState;
  // init initial marking and hash table
  isbounded = 1;
  if(gmflg)
  {
	graphstream = new ofstream(graphfile);
	if(!*graphstream)
	{
		cerr << "cannot open graph output file: " << graphfile << "\n";
		cerr << "no output written\n";
		gmflg = false;
	}
  }
  Trace = new SearchTrace [CardStore];
  for(i = 0; i < HASHSIZE;i++)
    {
      HashTable[i] = (Decision *) 0;
    }
  NumberOfStates = 1;
  if(search_marking()) cerr << "Sollte eigentlich nicht vorkommen";
  CurrentState = insert_marking();
  CurrentState -> current = 0;
  CurrentState -> firelist = FIRELIST();
  CurrentState -> parent = (State *) 0;
#ifdef DEADLOCK
	if(!(CurrentState -> firelist) || ! (CurrentState -> firelist[0]))
	{
		// early abortion
		cout << "\ndead state found!\n";
		printstate();
		print_path(CurrentState);
		printincompletestates(CurrentState,graphstream,1);
		statistics(NumberOfStates,Edges,NonEmptyHash);
		return 1;
	}
#endif
#ifdef TSCC
	TSCCRepresentitives = (Statevector *) 0;
#endif
#ifdef BOUNDEDPLACE
	if(!CheckPlace)
	{
		cerr << "\nspecify place to be checked in analysis tak file\n";
		_exit(4);
	}
#endif
#ifdef DEADTRANSITION 
	if(!CheckTransition)
	{
		cerr << "\n specify transition to be checked in analysis task file!\n";
		_exit(4);
	}
	if(CheckTransition -> enabled)
	{
		// early abortion
		cout << "\ntransition " << CheckTransition -> name << " is not dead!\n";
		printstate();
		print_path(CurrentState);
		printincompletestates(CurrentState, graphstream,1);//1=toplevel

		statistics(NumberOfStates,Edges,NonEmptyHash);
		return 1;
	}
#endif

#if (defined ( STUBBORN ) && defined ( REACHABILITY ) )
  if(!CurrentState -> firelist )
	{
#ifdef EXTENDED
	CurrentState -> firelist = firelist();
#else
		// early abortion  
	      cout << "\nstate found!\n";
		  printstate();
		print_path(CurrentState);
		printincompletestates(CurrentState, graphstream,1);//1=toplevel
		statistics(NumberOfStates,Edges,NonEmptyHash);
		return 1;
#endif
         }
#endif
#if ( defined (REACHABILITY ) && ! defined ( STUBBORN ) ) 
for(i=0;i<Places[0]->cnt;i++)
{
	 if(Places[i]->current_marking != Places[i]->target_marking)
		 break;
}
if(i >= Places[0]->cnt) // target_marking found!
{
		// early abortion  
	      cout << "\nstate found!\n";
		printstate();
		print_path(CurrentState);
		printincompletestates(CurrentState, graphstream,1);//1=toplevel
		statistics(NumberOfStates,Edges,NonEmptyHash);
	 return 1; 
}
#endif
#ifdef COVER
  CurrentState -> NewOmega = (Place **) 0;
#endif
#ifdef STATEPREDICATE
	int res;
	if(!F)
	{	
		cerr << "\nspecify predicate in analysis task file!\n";
		_exit(4);
	}
	F = F -> reduce(&res);
	if(res<2) return res;	
	F = F -> posate();
	F -> tempcard = 0;
	F -> setstatic();
	if(F ->  tempcard) 
	{
		cerr << "temporal operators are not allowed in state predicates\n";
		exit(3);
	}
	cout << "\n Formula with\n" << F -> card << " subformula.\n";
	F -> parent = (formula *) 0;
	if(F -> initatomic())
	{
		cout << "\nstate found!\n";
		printstate();
		print_path(CurrentState);
		printincompletestates(CurrentState,graphstream,1);
		statistics(NumberOfStates,Edges,NonEmptyHash);
		return 1;
	}
#endif
  CurrentState -> succ = new State * [CardFireList+1];
  CurrentState -> dfs = CurrentState -> min = 0;
  
  // process marking until returning from initial state
  
  while(CurrentState)
    {
#ifdef EXTENDED
	// dfsnum must be passed to net.H for tracing lastdisabed and lastfired
	currentdfsnum = CurrentState -> dfs + 1; // 0 reserved for "never disabled"
											 // and "never fired"
#endif
      if(CurrentState -> firelist[CurrentState -> current])
	{
	  // there is a next state that needs to be explored
	  Edges ++;
	      if(!(Edges % REPORTFREQUENCY)) 
              cerr << "st: " << NumberOfStates << "     edg: " << Edges << "\n";
	  CurrentState -> firelist[CurrentState -> current] -> fire();
#ifdef COVER
	//In coverability graphs, we need to check for new w

	// 1. Search backwards until last w-Intro for smaller state
	Statevector * smallerblock;
	unsigned int NrCovered;
	unsigned int blockindex;
	unsigned int smallerfirst, smallerlast;
	State * smallerstate;
	Place ** NewOmegas;

	NewOmegas = (Place **)0;
	// for all ancestor states do ...
	for(smallerstate = CurrentState; smallerstate; smallerstate =
	    smallerstate -> parent)
	{

		NrCovered = 0;
		// for all fragements of state vector do ...
		smallerfirst = Places[0]->cnt;
		for(smallerblock = smallerstate -> contents;
			smallerblock;
			smallerblock = smallerblock -> prev)
		{
			smallerlast = smallerfirst;
			smallerfirst = Places[0]->cnt - smallerblock->length;
			// for all elements in block ....
			for(blockindex= 0;blockindex < smallerlast - smallerfirst;
				blockindex++)
			{
				// case 1: smaller state[i] > current state [i] 
				// ---> continue with previous state
				if((*smallerblock)[blockindex] > Places[blockindex+smallerfirst]->current_marking)
				{
					goto nextstate;
				}
				// case 2: smaller state < current state
				// count w-Intro
				if((*smallerblock)[blockindex] < Places[blockindex+smallerfirst]->current_marking)
				{
					NrCovered++;
				}
				// case 3: smaller state = current state --> do nothing
			}
		}
		// if arrived here, it holds smaller <= current
		// covering is proper iff NrCovered > 0
		// If covering is not proper, (smaller state = current state)
		// current marking is not new, ancestors of smaller marking cannot
		// be smaller than current marking, since they would be smaller than
		// this smaller marking --> leave w-Intro procedure
		if(!NrCovered) 
		{
			smallerstate = (State *) 0;
			goto endomegaproc;
		}
		// Here, smallerstate IS less than current state.
		isbounded = 0;
		NewOmegas = new Place * [NrCovered+1];
		// for all fragements of state vector do ...
		NrCovered = 0;
		smallerfirst = Places[0]->cnt;
		for(smallerblock = smallerstate -> contents;
			smallerblock;
			smallerblock = smallerblock -> prev)
		{
			smallerlast = smallerfirst;
			smallerfirst = Places[0]->cnt - smallerblock->length;
			// for all elements in block ....
			for(blockindex= 0;blockindex < smallerlast - smallerfirst;
				blockindex++)
			{
				if((*smallerblock)[blockindex] < Places[blockindex+smallerfirst]->current_marking)
				{
					// Here we have a place that deserves a new Omega
					// 1. set old value in place record
					Places[blockindex+smallerfirst] -> lastfinite = 
					 Places[blockindex+smallerfirst] -> current_marking;
					Places[blockindex+smallerfirst] -> set_marking(VERYLARGE);
					Places[blockindex+smallerfirst] -> bounded = false;
					NewOmegas[NrCovered++] = Places[blockindex+smallerfirst];
				}
			}
		}
		NewOmegas[NrCovered] = (Place*) 0;
		goto endomegaproc;

			
	nextstate:
		if(smallerstate -> smaller) // smallerstate is a omega-introducing state
		{
			break;
		}
	}
endomegaproc:
if(!NewOmegas) smallerstate = (State *) 0;
#endif
	  if(NewState = 
#ifdef SYMMETRY
SYMMPROC()
#else
search_marking()
#endif
)
	    {
		  // State exists!
#ifdef COVER
		  if(NewOmegas)
		  {
			  // Replace new omegas by their old values
			  for(i=0;NewOmegas[i];i++)
			  {
				NewOmegas[i]->set_marking(NewOmegas[i]->lastfinite);
				NewOmegas[i]->bounded = true;
			  }
			  delete [] NewOmegas;
		  }
#endif
	      CurrentState -> firelist[CurrentState -> current] -> backfire();
#ifdef STATEPREDICATE
	update_formula(CurrentState -> firelist[CurrentState -> current]);
#endif
	      CurrentState -> succ[CurrentState -> current] = NewState;
	      CurrentState -> min = MIN(CurrentState -> min, NewState -> min);
	      (CurrentState -> current) ++;
	    }
	  else
	    {
	      NewState = 
#if ( defined ( SYMMETRY ) )  && ( SYMMINTEGRATION > 2 )
kr_insert_marking();
#else
insert_marking();
#endif
#ifdef STATEPREDICATE
	update_formula(CurrentState -> firelist[CurrentState -> current]);
#endif
	      NewState -> current = 0;
	      NewState -> firelist = FIRELIST();
	      NewState -> parent = CurrentState;
	      NewState -> succ =  new State * [CardFireList+1];
	      NewState -> dfs = NewState -> min = NumberOfStates++;
	      CurrentState -> succ[CurrentState -> current] = NewState;
#ifdef STATEPREDICATE
	if(F -> value)
	{
		// early abortion
		cout << "\nstate found!\n";
		printstate();
		print_path(NewState);
		printincompletestates(NewState, graphstream,1);//1=toplevel
		statistics(NumberOfStates,Edges,NonEmptyHash);
		return 1;
	}
#endif
#ifdef COVER
	NewState -> smaller = smallerstate;
	NewState -> NewOmega = NewOmegas;
#endif
#ifdef DEADLOCK
	if(!(NewState -> firelist) || !(NewState -> firelist[0]))
	{
		// early abortion
		cout << "\ndead state found!\n";
		printstate();
		print_path(NewState);
		printincompletestates(NewState, graphstream,1);//1=toplevel
		statistics(NumberOfStates,Edges,NonEmptyHash);
		return 1;
	}
#endif
#ifdef DEADTRANSITION 
	if(CheckTransition -> enabled)
	{
		// early abortion
		cout << "\ntransition " <<  CheckTransition -> name << " is not dead!\n";

		printstate();
		print_path(NewState);
		printincompletestates(NewState, graphstream,1);//1=toplevel
		statistics(NumberOfStates,Edges,NonEmptyHash);
		return 1;
	}
#endif
#if ( defined ( STUBBORN ) && defined ( REACHABILITY ) ) 
  if(!NewState -> firelist )
	{
#ifdef EXTENDED
		NewState -> firelist = firelist();
#else
		// early abortion  
	      cout << "\nstate found!\n";
		  printstate();
		print_path(NewState);
		printincompletestates(NewState, graphstream,1);//1=toplevel
		statistics(NumberOfStates,Edges,NonEmptyHash);
		return 1;
#endif
         }
#endif
#if ( defined (REACHABILITY ) && ! defined ( STUBBORN ) ) 
for(i=0;i<Places[0]->cnt;i++)
{
	 if(Places[i]->current_marking != Places[i]->target_marking)
		 break;
}
if(i >= Places[0]->cnt) // target_marking found!
{
		// early abortion  
	      cout << "\nstate found!\n";
		  printstate();
		print_path(NewState);
		printincompletestates(NewState, graphstream,1);//1=toplevel
		statistics(NumberOfStates,Edges,NonEmptyHash);
	 return 1; 
}
#endif

	      CurrentState = NewState;
#ifdef COVER
	if(CheckPlace)
	{
		if(!CheckPlace -> bounded)
		{
			cout << "place " << CheckPlace -> name << " is unbounded!\n";
			print_reg_path(CurrentState,CurrentState->smaller,(ofstream *) 0,1);
			cout << "\n";
		printincompletestates(CurrentState,graphstream,1);
		statistics(NumberOfStates,Edges,NonEmptyHash);
			return 1;
		}
	}
#endif
	    }
	}
      else
	{
	  // close state and return to previous state
	int j;
	if(gmflg)
	{
	  (*graphstream) << "STATE " << CurrentState ->dfs;
	  j=0;
	  if(graphformat == 'm')
	  {
		 for(i=0;i<Places[0]->cnt;i++)
		 {
			 if(Places[i]->current_marking)
			 {
				 if(Places[i]->current_marking == VERYLARGE)
				 {

				 (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo" ;
				 }
				 else
				 {
				 (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
				 }
				 }
		 }

	  }
	  (*graphstream) << "\n\n";
	  for(i=0; CurrentState ->firelist[i];i++)
	  {
		(*graphstream) << CurrentState -> firelist[i]->name << " -> " <<
		CurrentState -> succ[i]->dfs << "\n";
      }
	  (*graphstream) << "\n";
	}
	if(GMflg)
	{
	  cout << "STATE " << CurrentState ->dfs;
	  j=0;
	  if(graphformat == 'm')
	  {
		 for(i=0;i<Places[0]->cnt;i++)
		 {
			 if(Places[i]->current_marking)
			 {
				 if(Places[i]->current_marking == VERYLARGE)
				 {
				 cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo" ;
				 }
				 else
				 {
				 cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
				 }
			 }
		 }

	  }
	  cout << "\n\n";
	  for(i=0; CurrentState ->firelist[i];i++)
	  {
		cout << CurrentState -> firelist[i]->name << " -> " <<
		CurrentState -> succ[i]->dfs << "\n";
      }
	  cout << "\n";
	}
#if defined(EXTENDED) && ! defined(MODELCHECKING)
		// if last state in TSCC, retrieve ignored transitions
		if((CurrentState -> dfs == CurrentState -> min)
			&& (CurrentState -> dfs >= MinBookmark))
		{
			// TSCC closed. Check for ignored transitions or incomplete up-sets
#ifdef STATEPREDICATE
			// implement SPP2 of Kristensen/Valmari (2000)
			Transition ** forgotten;

			forgotten = F -> spp2(CurrentState);
			if(forgotten)
			{
				// fire list must be extended
				unsigned int nf;
				for(nf = 0; forgotten[nf]; nf++);
				Transition ** newFL = new Transition * [nf + CurrentState -> current];
				State ** newSucc = new State * [nf + CurrentState -> current];
				for(i=0;i < CurrentState -> current;i++)
				{
					newFL[i] = CurrentState -> firelist[i];
					newSucc[i] = CurrentState -> succ[i];
				}
				for(i=0;i<nf;i++)
				{
					newFL[CurrentState -> current + i] = forgotten[i];
				}
				newFL[i] = (Transition *) 0;
				delete [] CurrentState -> firelist;
				delete [] CurrentState -> succ;
				CurrentState -> firelist = newFL;
				CurrentState -> succ = newSucc;
				continue;
			}

#else
			Transition * ignored;
			unsigned int CardIgnored;

			CardIgnored = 0;
			Transitions[0]-> StartOfIgnoredList = (Transition *) 0;
			for(ignored = Transitions[0]->StartOfEnabledList;ignored;
				ignored = ignored -> NextEnabled)
			{
				if((ignored -> lastdisabled <= CurrentState -> dfs)
					&& (ignored -> lastfired <= CurrentState -> dfs))
				{
					// transition IS ignored
					CardIgnored ++;
					ignored -> NextIgnored = Transitions[0]->StartOfIgnoredList;
					Transitions[0]->StartOfIgnoredList = ignored;
				}
			}
			if(Transitions[0]->StartOfIgnoredList)
			{
				// there are ignored transitions
				Transition * tt;
				Transition ** newFL = new Transition *[CurrentState -> current + CardIgnored + 1];
				State ** newSucc = new State *[CurrentState->current + CardIgnored];
				int u;
				for(u=0;u<CurrentState->current;u++)
				{
					newFL[u]= CurrentState->firelist[u];
					newSucc[u] = CurrentState -> succ[u];
				}
				for(tt = Transitions[0]->StartOfIgnoredList;
				    tt;
				    tt = tt -> NextIgnored)
				{
					newFL[u++] = tt;
				}
				newFL[u] = (Transition*)0;
				delete [] CurrentState -> firelist;
				delete [] CurrentState -> succ;
				CurrentState->firelist = newFL;
				CurrentState -> succ = newSucc;
				continue;
			}
#ifdef TSCC
			else
			{
				//TSCC really closed: deposit state
				Statevector * s;

				MinBookmark = NumberOfStates;
				s = new Statevector(Places[0]->cnt);
				s -> prev = TSCCRepresentitives;
				TSCCRepresentitives = s;
				for(i=0;i < Places[0]->cnt;i++)
				{
					s->set(i,Places[i]->current_marking);
				}
			}
#endif
#endif
		}
#endif
#ifdef COVER
		  if(CurrentState -> NewOmega)
		  {
			  // Replace new omegas by their old values
			  for(i=0;CurrentState ->NewOmega[i];i++)
			  {
				CurrentState ->NewOmega[i]->set_marking(CurrentState ->NewOmega[i]->lastfinite);
				CurrentState ->NewOmega[i]->bounded = true;
			  }
			  delete [] CurrentState ->NewOmega;
		  }
#endif
	  delete [] CurrentState -> succ;
	  delete [] CurrentState -> firelist;
	  CurrentState = CurrentState -> parent;
	  if(CurrentState)
	    {
	      CurrentState -> firelist[CurrentState -> current] -> backfire();
#ifdef STATEPREDICATE
		  update_formula(CurrentState -> firelist[CurrentState -> current]);
#endif
	      CurrentState -> min = MIN(CurrentState -> min, CurrentState-> succ[CurrentState -> current]-> min);
	      CurrentState -> current ++;
	    }
	}
	}
#ifdef REACHABILITY
	cout << "\n state is not reachable!\n";
#endif
#ifdef DEADLOCK
	cout << "\nnet does not have deadlocks!\n";
#endif
#ifdef STATEPREDICATE
	cout << "\n predicate is not satisfiable!\n";
#endif
#ifdef DEADTRANSITION
	cout << "\ntransition " << CheckTransition -> name << " is dead!\n";
#endif
#ifdef BOUNDEDPLACE
	cout << "\nplace " << CheckPlace -> name << " is bounded!\n";
#endif
#ifdef BOUNDEDNET
	if(isbounded)
	{
		cout << "\nnet is bounded!\n";
	}
	else
	{
		cout << "\nnet is unbounded!\n";
	}
#endif
	statistics(NumberOfStates,Edges,NonEmptyHash);
	return 0;
}


unsigned int breadth_first()
{
  ofstream * graphstream;
  unsigned int limit;
  unsigned int d;
  unsigned int i;
  unsigned int NumberOfStates;

  if(gmflg)
  {
	  graphstream = new ofstream(graphfile);
		if(!graphstream)
		{
			cerr << "Cannot open graph output file: " << graphfile
			<< "\nno output written\n";
			gmflg = false;
		}
  }
		

  State * CurrentState, * NewState, * initial;
  // init initial marking and hash table
  Trace = new SearchTrace [CardStore];
  for(i = 0; i < HASHSIZE;i++)
    {
      HashTable[i] = (Decision *) 0;
    }
  NumberOfStates = d = limit = 1;
  initial = CurrentState = insert_marking();
  CurrentState -> dfs = 0;
  CurrentState -> current = 0;
  CurrentState -> min = true;
  CurrentState -> firelist = FIRELIST();
	int j;
	if(gmflg)
	{
	  (*graphstream) << "STATE " << CurrentState ->dfs << "; DEPTH 0";
	  j=0;
	  if(graphformat == 'm')
	  {
		 for(i=0;i<Places[0]->cnt;i++)
		 {
			 if(Places[i]->current_marking)
			 {
				 if(Places[i]->current_marking == VERYLARGE)
				 {
				 (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo" ;
				 }
				 else
				 {
				 (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
				 }
			 }
		 }

	  }
	  (*graphstream) << "\n\n";
	  for(i=0;CurrentState -> firelist[i];i++)
	  {
		(*graphstream) << CurrentState -> firelist[i]->name << "\n";
	  }
	  (*graphstream) << "\n";
	}
	if(GMflg)
	{
	  cout << "STATE " << CurrentState ->dfs << "; DEPTH 0";
	  j=0;
	  if(graphformat == 'm')
	  {
		 for(i=0;i<Places[0]->cnt;i++)
		 {
			 if(Places[i]->current_marking)
			 {
				 if(Places[i]->current_marking == VERYLARGE)
				 {
				 cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo" ;
				 }
				 else
				 {
				 cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
				 }
			 }
		 }

	  }
	  cout << "\n\n";
	  for(i=0;CurrentState -> firelist[i];i++)
	  {
		cout << CurrentState -> firelist[i]->name << "\n";
	  }
	  cout << "\n";
	}
#ifdef STUBBORN
  if(!CurrentState -> firelist )
	{
		// early abortion  
#ifdef REACHABILITY
	      cout << "\nstate found!\n";
#endif
#ifdef DEADTRANSITION
	      cout << "\ntransition " << CheckTransition -> name << " is not dead!\n";
#endif
		  printstate();
		  print_path(CurrentState);
	statistics(NumberOfStates,Edges,NonEmptyHash);
	return 1;
         }
#endif
#ifdef DEADLOCK 
	if(!CurrentState -> firelist || ! (CurrentState -> firelist[0]))
	{
		 // early abortion 
		 cout << "\ndead state found!\n";
		 printstate();
		 print_path(CurrentState);
		 statistics(NumberOfStates,Edges,NonEmptyHash);
		 return 1;
	}
#endif

#if ( defined (REACHABILITY ) && ! defined ( STUBBORN ) ) 
for(i=0;i<Places[0]->cnt;i++)
{
	 if(Places[i]->current_marking != Places[i]->target_marking)
		 break;
}
if(i >= Places[0]->cnt) // target_marking found!
{
		// early abortion  
#ifdef REACHABILITY
	      cout << "\nstate found!\n";
#endif
#ifdef DEADTRANSITION
	      cout << "\nstransition " CheckTransition -> name << " is not dead!\n";
#endif
		  printstate();
		print_path(CurrentState);
	statistics(NumberOfStates,Edges,NonEmptyHash);
	 return 1; 
}
#endif
  CurrentState -> parent = (State *) 0;
  CurrentState -> succ = new State * [CardFireList];
  
  // process marking until returning from initial state
  
  while(CurrentState)
    {
      if(CurrentState -> firelist[CurrentState -> current])
	{
          if(d == limit)
	  {
		// working layer
	        Edges ++;
	      if(!(Edges % REPORTFREQUENCY)) 
              cerr << "st: " << NumberOfStates << "     edg: " << Edges << "\n";
	        CurrentState -> firelist[CurrentState -> current] -> fire();
	        if(NewState = 
#ifdef SYMMETRY
SYMMPROC()
#else
search_marking()
#endif
)
	        {
	            CurrentState -> firelist[CurrentState -> current] -> backfire();
	            CurrentState -> succ[(CurrentState -> current)++] = (State *) 0;
	        }
	        else
	        {
	            NewState = 
#if ( defined ( SYMMETRY ) )  && ( SYMMINTEGRATION > 2 )
kr_insert_marking();
#else
insert_marking();
#endif
		    CurrentState -> min = true;
                NewState -> dfs =  NumberOfStates ++;
	            NewState -> current = 0;
	            NewState -> firelist = FIRELIST();
	            NewState -> parent = CurrentState;
	            NewState -> succ =  new State * [CardFireList];
	if(gmflg)
	{
	  (*graphstream) << "STATE " << NewState ->dfs << " FROM " <<
	  CurrentState -> dfs << " BY " << 
	  CurrentState -> firelist[CurrentState -> current] -> name
	  << "; DEPTH " << limit;
	  j=0;
	  if(graphformat == 'm')
	  {
		 for(i=0;i<Places[0]->cnt;i++)
		 {
			 if(Places[i]->current_marking)
			 {
				 if(Places[i]->current_marking == VERYLARGE)
				 {
				 (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo" ;
				 }
				 else
				 {
				 (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
				 }
			  }
		 }

	  }
	  (*graphstream) << "\n\n";
	  if(NewState -> firelist)
	  {
	  for(i=0;NewState -> firelist[i];i++)
	  {
		(*graphstream) << NewState -> firelist[i]->name << "\n";
	  }
	  }
	  (*graphstream) << "\n";
	}
	if(GMflg)
	{
	  cout << "STATE " << NewState ->dfs << " FROM " <<
	  CurrentState -> dfs << " BY " << 
	  CurrentState -> firelist[CurrentState -> current] -> name
	  << "; DEPTH " << limit;
	  j=0;
	  if(graphformat == 'm')
	  {
		 for(i=0;i<Places[0]->cnt;i++)
		 {
			 if(Places[i]->current_marking)
			 {
				 if(Places[i]->current_marking == VERYLARGE)
				 {
				 cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo" ;
				 }
				 else
				 {
				 cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
				 }
			 }
		 }

	  }
	  cout << "\n\n";
	  if(NewState -> firelist)
	  {
	  for(i=0;NewState -> firelist[i];i++)
	  {
		cout << NewState -> firelist[i]->name << "\n";
	  }
	  }
	  cout << "\n";
	}
	            CurrentState -> succ[CurrentState -> current] = NewState;
#ifdef STUBBORN
                    if(!NewState -> firelist )
	            {
		        // early abortion  
#ifdef REACHABILITY
	                cout << "\nstate found!\n";
#endif
#ifdef DEADTRANSITION
	                cout << "\ntransition " << CheckTransition -> name << " is not dead!\n";
#endif
					printstate();
		        print_path(NewState);
	statistics(NumberOfStates,Edges,NonEmptyHash);
		        return 1;
                    }
#endif
#ifdef DEADLOCK
                if(!NewState -> firelist || !(NewState -> firelist[0]))
	            {
		        // early abortion  
	                cout << "\ndead state found!\n";
					printstate();
		        print_path(NewState);
	statistics(NumberOfStates,Edges,NonEmptyHash);
		        return 1;
                    }
#endif
#if ( defined (REACHABILITY ) && ! defined ( STUBBORN ) ) 
for(i=0;i<Places[0]->cnt;i++)
{
	 if(Places[i]->current_marking != Places[i]->target_marking)
		 break;
}
if(i >= Places[0]->cnt) // target_marking found!
{
		// early abortion  
	      cout << "\nstate found!\n";
		  printstate();
		print_path(NewState);
	statistics(NumberOfStates,Edges,NonEmptyHash);
	 return 1; 
}
#endif

	            CurrentState->firelist[CurrentState -> current]->backfire();
		    CurrentState->current++;
	    }
	}
	else
        {
		// proceed forward to working layer
		if(CurrentState -> succ[CurrentState -> current])
		{	
			CurrentState -> firelist[CurrentState -> current]->fire();
			CurrentState = CurrentState->succ[CurrentState->current];
			CurrentState -> min = false;
			CurrentState -> current = 0;
			d++;
		}
		else
		{
			(CurrentState -> current)++;
		}
	}
      }
      else
	{
	  // close state and return to previous state
		// new state closed
	  if(CurrentState -> min)
	  {
		  CurrentState = CurrentState -> parent;
                  if(CurrentState) CurrentState -> min = true;
	  }
	  else
	  {
		  CurrentState = CurrentState -> parent;  
	          if(CurrentState) CurrentState -> succ[CurrentState -> current] = (State *) 0;
	  }
	  
	  d--;
	  if(CurrentState)
	    {
	      CurrentState -> firelist[CurrentState -> current] -> backfire();
	      CurrentState -> current ++;
	    }
	  else
	    {
		if(initial->min)
		{
		limit++;
		d = 1;
		CurrentState = initial;
		CurrentState -> current = 0;
		initial-> min = false;
		}
            }
	}
	}
	statistics(NumberOfStates,Edges,NonEmptyHash);
	return 0;
}
	  
void RemoveGraph()
{
	int i;

	for(i=0;i<HASHSIZE;i++)
	{
		if(HashTable[i]) delete HashTable[i];
		HashTable[i] = (Decision *) 0;
	}
}

#ifdef STUBBORN
bool mutual_reach()
{
  unsigned int i;
  unsigned int NumberOfStates;
  State * NewState;
  // init initial marking and hash table
  Trace = new SearchTrace [CardStore];
  RemoveGraph();
  NumberOfStates = 1;
  NonEmptyHash = 0;
  if(search_marking())
  {
	cerr << " Wat soll dat denn?";
  }
  CurrentState = insert_marking();
  CurrentState -> current = 0;
  Edges = 0;
  CurrentState -> firelist = stubbornfirelistreach();

  if(!CurrentState -> firelist )
	{
		// early abortion  
  statistics(NumberOfStates,Edges,NonEmptyHash);
		return true;
    }
  CurrentState -> parent = (State *) 0;
  CurrentState -> succ = new State * [CardFireList];
  
  // process marking until returning from initial state
  
  while(CurrentState)
    {
      if(CurrentState -> firelist[CurrentState -> current])
	{
	  // there is a next state that needs to be explored
	  Edges ++;
	      if(!(Edges % REPORTFREQUENCY)) 
              cerr << "st: " << NumberOfStates << "     edg: " << Edges << "\n";
	  CurrentState -> firelist[CurrentState -> current] -> fire();
	  if(NewState = 
#ifdef SYMMETRY
SYMMPROC()
#else
search_marking()
#endif
)
	    {
		  // State exists!
	      CurrentState -> firelist[CurrentState -> current] -> backfire();
	      CurrentState -> succ[CurrentState -> current] = NewState;
	      (CurrentState -> current) ++;
	    }
	  else
	    {
	      NewState = 
#if ( defined ( SYMMETRY ) )  && ( SYMMINTEGRATION > 2 )
kr_insert_marking();
#else
insert_marking();
#endif
	      NewState -> current = 0;
	      NewState -> firelist = stubbornfirelistreach();
	      NewState -> parent = CurrentState;
	      NewState -> succ =  new State * [CardFireList];
	      CurrentState -> succ[CurrentState -> current] = NewState;
  if(!NewState -> firelist )
	{
		// early abortion  
  statistics(NumberOfStates,Edges,NonEmptyHash);
		return true;
    }
	      CurrentState = NewState;
	    }
	}
      else
	{
	  // close state and return to previous state
	  CurrentState = CurrentState -> parent;
	  if(CurrentState)
	    {
	      CurrentState -> firelist[CurrentState -> current] -> backfire();
	      CurrentState -> current ++;
	    }
	}
    }
  statistics(NumberOfStates,Edges,NonEmptyHash);
  return false;
}

#endif

#ifdef REVERSIBILITY
int reversibility()
{
	unsigned int i;
	for(i=0;i<Places[0]->cnt;i++)
	{
		Places[i]->initial_marking = Places[i] -> current_marking;
	}
	// Compute representitives of all TSCC 
	depth_first();
	//Check whether initial marking is reachable
	for(;TSCCRepresentitives;TSCCRepresentitives = TSCCRepresentitives->prev)
	{
		// 1. initialize start and target markings
		for(i=0;i < Places[0]->cnt;i++)
		{	
			Places[i]->target_marking = Places[i]->initial_marking;
			Places[i]->set_marking((*TSCCRepresentitives)[i]);
		}
		for(i=0;i<Transitions[0]->cnt;i++)
		{
			Transitions[i]->check_enabled();
		}
		if(!mutual_reach())
		{
			cout << "\nnot reversible: no return to m0 from reported state\n\n";
			printstate();
			return 1;
		}
	}
	cout << "\n net is reversible!\n";
	return(0);
}
#endif

#ifdef HOME

int home()
{
	unsigned int i;
	Statevector * New, * Old, * Candidate;

	// Compute representitives of all TSCC 
	depth_first();
	Candidate = TSCCRepresentitives;
	if(!Candidate)
	{
		cout << "serious internal error, maybe memory overflow?\n";
		_exit( 2);
	}
	New = Candidate -> prev;
	Old = (Statevector *) 0;

	// First loop creates candidate for home property
	while(New)
	{
		// 1. initialize start and target markings
		for(i=0;i < Places[0]->cnt;i++)
		{	
			Places[i]->target_marking = (*Candidate)[i];
			Places[i]->set_marking((*New)[i]);
		}
		for(i=0;i<Transitions[0]->cnt;i++)
		{
			Transitions[i]->check_enabled();
		}
		if(!mutual_reach())
		{
			Candidate -> prev = Old;
			Old = Candidate;
			Candidate = New;
		}
		New = New -> prev;
	}
	while(Old)
	{
		// 1. initialize start and target markings
		for(i=0;i < Places[0]->cnt;i++)
		{	
			Places[i]->target_marking = (*Candidate)[i];
			Places[i]->set_marking((*Old)[i]);
		}
		for(i=0;i<Transitions[0]->cnt;i++)
		{
			Transitions[i]->check_enabled();
		}
		if(!mutual_reach())
		{
			cout << "\nnet does not have home markings!\n\n";
			return 1;
		}
		Old = Old -> prev;
	}
	cout << "\n\n home marking found (reported state)\n\n";
	for(i=0;i<Places[0]->cnt;i++)
	{
		Places[i]->set_marking((*Candidate)[i]);
	}
	printstate();
	return(0);
}
		
#endif

#endif
