function [srcexp, srcvar, netexp, netvar] =...
    feedbackpca(x, net, sources, data, noisevari, sourcevar, missing)

if nargin < 5
  noisevar = .1 * ones(size(data, 1), 1);
else
  noisevar = exp(2*(noisevari.e - noisevari.var));
end
if nargin < 7
  missing = sparse(size(data, 1), size(data, 2));
end;

%sourcevar = 1;
weightvar = 1;
nsampl = size(data, 2);
nsources = size(sources, 1);

datavars = (1 ./ noisevar) * ones(1, nsampl);
datavars = datavars - missing .* datavars;

bpvar = .5 .* datavars;
bpexp = (x.e - data) .* datavars;

% The first layer (linear)

bpexpb = net.w1.e' * bpexp + (2*net.w1.var' * bpvar) .* sources.e;
bpvarb = (net.w1.e' .^2 + net.w1.var') * bpvar;

netexp.w1 = bpexp * sources.e' + ...
    2 * (bpvar * sources.var') .* net.w1.e + ...
    net.w1.e / weightvar;
netvar.w1 = bpvar * (sources.var + sources.e .^ 2)' + .5 / weightvar;

netexp.b1 = repmat(sum(bpexp, 2), 1, nsampl) + net.b1.e / weightvar;
netvar.b1 = repmat(sum(bpvar, 2), 1, nsampl) + .5 / weightvar;

srcexp = bpexpb + sources.e ./ (sourcevar * ones(1, nsampl));
srcvar = bpvarb + .5 ./ (sourcevar * ones(1, nsampl));
