function noisevar = calcnoisevar(data, mydata, missing)
% CALCNOISEVAR  calculate an estimate for noise variance
%   from the data and our reconstruction of it
%
%   Usage:
%     nvar = calcnoisevar(origdata, mydata, missing)
%     where origdata is double and mydata probdist.

% Antti Honkela 1999
mydata(find(missing)) = probdist(0, 0);
s2eff = sum((data - mydata.e).^2 + mydata.var, 2) ./ ...
	(size(data, 2) - sum(missing, 2));
vvar = .5 ./ (size(data, 2) - sum(missing, 2));
vexp = vvar + .5 * log(s2eff);

noisevar = probdist(vexp, vvar);

