function speech_som(filename, origdata, missing, maxsigma);

somname = sprintf('%s_som',filename);
somnamemat = sprintf('%s_som.mat',filename);
som_use_vs2
data = origdata;
data(find(missing)) = NaN;

sigma = 0.01:0.1:maxsigma+0.01;
alpha = 1./(2*sigma.^2);
bestsomrec = [];
bestsomerro2 = 9999999999;
firstsi = 1;

if (~isempty(dir(somnamemat))),
  load(somname);
  firstsi = size(erro2,2) + 1;
  fprintf('Loaded file %s, starting from size %d.\n',somname, firstsi);
end;  
  
for si = firstsi:40;
  sMap = som_make(data','munits',100*si);
  sMap = som_batchtrain(sMap, data','radius',0,'neigh','bubble','trainlen',50);

  [Bmus, Qerrs] = som_bmus(sMap, data', [1:size(sMap.codebook,1)]);
  Qerrs = Qerrs.^2;
  distance = Qerrs - repmat(min(Qerrs, [], 2), 1, ...
			  size(sMap.codebook, 1));
  for i=1:length(sigma),
    weight = exp(-alpha(i)*distance);
    somrec = zeros(size(data'));
    for sam=1:size(weight, 1),
      somrec(sam,:) = (weight(sam,:) * sMap.codebook(Bmus(sam, :),:)) / ...
          sum(weight(sam, :), 2);
    end;
    fprintf('.');
    somrec = somrec';
    err = somrec - origdata;
    erro2(i,si) = mean(err(find(missing)).^2);
    erro2b(i,si) = mean(err(find(1-missing)).^2);
    if (bestsomerro2>erro2(i,si)),
      bestsomrec = somrec;
      bestsomerro2 = erro2(i,si);
    end;
    save(somname,'erro2','erro2b','alpha','sMap','bestsomrec');
  end;
end;
