function speech_show_rec(filename, origdata, missing, ss, hidn)

somname = sprintf('%s_som',filename);
lfaname = sprintf('%s_lfa',filename);
nlfaname = sprintf('%s_nlfa_%d_%d',filename,ss, hidn);
if (length(nlfaname)==length('speech_patch_nlfa_15_30')),
  if (nlfaname=='speech_patch_nlfa_15_30')
    nlfaname = 'speech_patch2_nlfa_15_30';
  end;
end;
load(somname)
load(lfaname)
load(nlfaname)

%load parzenrecneig2;
%load sombigrecneig2;
%load nlfarecneig2;
%load linearrecneig2;

saltdata = origdata;
white = max(max(origdata));
saltdata(find(missing)) = white;

p1 = 2495;
p2 = 2495-300;

subplot(512);
imagesc([origdata(:,end-p1:end-p2)]);
colormap(gray); axis off; 
title('Original data');

subplot(511);
imagesc([saltdata(:,end-p1:end-p2)]);
colormap(gray); axis off;
title('Data with missing values');

subplot(514);
imagesc([nlfarec.e(:,end-p1:end-p2)]);
colormap(gray); axis off;
title('NFA reconstruction');

subplot(515);
imagesc([bestlfarec.e(:,end-p1:end-p2)]);
colormap(gray); axis off;
title('FA reconstruction');

subplot(513);
imagesc([bestsomrec(:,end-p1:end-p2)]);
colormap(gray); axis off;
title('SOM reconstruction');
