function speech_run(filename, speech, permu, patch, randseed);

[origdata, missing] = speech_data(speech, permu, patch, randseed);
[ndim, nsampl] = size(origdata);

speech_som(filename, origdata, missing, 2+2*speech);
  fprintf('SOM done. (%s)\n', filename); 
speech_lfa(filename, origdata, missing, 400);
  fprintf('LFA done. (%s)\n', filename);
if (speech)
  nlfass = [2 5 8 12 15 18];
  nlfahns = [30 30 30 30 30 30];
else
  nlfass = [1 2 3 5 7 9];
  nlfahns = [20 20 20 20 20 20];
end;
for ssi=1:length(nlfass),
  speech_nlfa(filename, origdata, missing, nlfass(ssi), nlfahns(ssi), ...
	      5000, speech);
  fprintf('NLFA %d %d done. (%s)\n', nlfass(ssi), nlfahns(ssi), filename);
end;

% for plotting the projections later:
[s, V, D] = basicpca(origdata, ndim);
Vname = sprintf('%s_V',filename);
save(Vname,'V');
