function speech_nlfa(filename, origdata, missing, searchsources, ...
		     hidneurons, niters, speech);

nlfaname = sprintf('%s_nlfa_%d_%d',filename,searchsources, ...
		   hidneurons);
nlfanamemat = sprintf('%s_nlfa_%d_%d.mat',filename,searchsources, hidneurons);
data = origdata;
data(find(missing))=NaN;
[ndim, nsampl] = size(data);

if (~isempty(dir(nlfanamemat)))
  fprintf('Loading %s...',nlfaname);
  load(nlfaname);
  fprintf('ok.\n');
  sources = res.sources;
  status = res.status;
  net = res.net;
  params = res.params;
  hypers = res.hypers; 
  priors = res.priors;
  data(find(missing))=0;
else
 erro2 = [];
 erro2b = [];
 fprintf('Initialize new nlfa.\n');
 bpinit;
 status.iters = 100;
 status.batch_size = 1000;
end;

niters = niters-length(status.kls);
if (niters <= 0),
  return;
end;

for i = length(erro2)+1:length(erro2)+floor(niters/100),
  bpiter;
  if (or(isnan(status.kls(end)), status.kls(end) > status.kls(end-90)+1e7)),
    break;
  end;  
  x_temp = feedfw(sources, net);         
  err = x_temp{4}.e - origdata;
  erro2(i) = mean(err(find(missing)).^2);
  erro2b(i) = mean(err(find(1-missing)).^2);
   res.status = status;
   res.sources = sources;
   res.net = net;
   res.params = params;
   res.hypers = hypers;
   res.priors = priors;
   nlfarec = x_temp{4};
   save(nlfaname,'res','erro2','erro2b','nlfarec');
end;
