function speech_lfa(filename, origdata, missing, niters);

lfaname = sprintf('%s_lfa',filename);
data = origdata;

[ndim, nsampl] = size(data);

res = cell(ndim,1);
bestlfarec = [];
bestlfaerro2 = 9999999999;
for dim = 1:ndim,
  data(find(missing)) = NaN;
  [transf, bias, sources, kls] = pcaiter(data, dim, niters);
  res{dim}.transf = transf;
  res{dim}.bias = bias;
  res{dim}.bias = res{dim}.bias(:,1);
  res{dim}.kls = kls;
  linekls(dim) = res{dim}.kls(end);
  linearrec = transf * sources + bias;
  err = linearrec.e - origdata;
  erro2(dim) = mean(err(find(missing)).^2);
  erro2b(dim) = mean(err(find(1-missing)).^2);
  if (bestlfaerro2>erro2(dim)),
    bestlfarec = linearrec;
    bestlfaerro2 = erro2(dim);
  end;
   save(lfaname,'res','erro2','erro2b','bestlfarec');
end;
