function [origdata, missing] = speech_data(speech, permu, patch, randseed);

if (speech)
  load sp_data_1
  matchdata = data;
  load sp_data_2
else
  load housingdata;
  matchdata = data(:,1:floor(size(data,2)*0.7));
  data = data(:,floor(size(data,2)*0.7)+1:end);
end;
[ndim, nsampl] = size(data);
 

if (permu)
  %make a random permutation
  bothdata = [matchdata data];
  rand('seed',randseed);
  bothdata = bothdata(:, randperm(size(bothdata, 2)));
  matchdata = bothdata(:, 1:size(matchdata, 2));
  data = bothdata(:, size(matchdata, 2)+1:end);
  clear bothdata;
end;

origdata = data;
rand('seed',randseed);

if (patch)
  missing = sparse(rand(size(data))<0.03); % <0.1);
missing = missing + missing([2:ndim 1], :) + ...
	  missing([3:ndim 1:2], :) + missing([4:ndim 1:3], :);
missing = missing + missing(:, [2:nsampl 1]) +...
	  missing(:, [3:nsampl 1:2]) + missing(:, [4:nsampl 1:3]);
missing = (missing>0);

else
  missing = sparse(rand(size(data))<0.1);
end;


data(find(missing)) = 0;

data = [matchdata data];
origdata = [matchdata origdata];
missing = sparse([0*matchdata missing]);
