function speech_show_projection(filename,origdata,missing,nlfass,nlfahns,speech);

% Project to plane.

maxjjj = 3;
Vname = sprintf('%s_V',filename);
load(Vname);
somname = sprintf('%s_som',filename);

nrows = 3+length(nlfass);

for jjj=1:maxjjj
  if (speech)  
    axi = [-30 35 -20 30];
  else
    axi = [-6 6 -6 6];
  end;
  untransf = pinv(V(:,[1 jjj+1]));
  
  %som
  load(somname);
  projektio = untransf * sMap.codebook';
  subplot(maxjjj,nrows,3+nrows*jjj-nrows);
  plot(projektio(1,:),projektio(2,:),'.','MarkerSize',1)
  axis(axi); axis off; 
 
  %nlfa
  for i=1:length(nlfass),
    nlfaname = sprintf('%s_nlfa_%d_%d',filename,nlfass(i), ...
		   nlfahns(i));
  if (length(nlfaname)==length('speech_patch_nlfa_15_30')),
    if (nlfaname=='speech_patch_nlfa_15_30')
      nlfaname = 'speech_patch2_nlfa_15_30';
    end;
  end;
    load(nlfaname);
    nsampl = floor(0.5 * size(origdata, 2));
    s = randn(length(res.params.src.e),nsampl).*repmat(exp(res.params.src.e),1,nsampl);
    x = feedfw(s, res.net);
    projektio = untransf * x;
    subplot(maxjjj,nrows,3+i+nrows*jjj-nrows);
    plot(projektio(1,:),projektio(2,:),'.','MarkerSize',1)
    axis(axi); axis off;
  end;

  [x1,x2] = find(missing);
  ntrain = min(x2)-1;
  matchdata = origdata(:,1:ntrain);
  testdata = origdata(:,ntrain+1:end);

  %testdata
  load sp_data_2
  projektio = untransf * testdata;
  subplot(maxjjj,nrows,2+nrows*jjj-nrows);
  plot(projektio(1,:),projektio(2,:),'.','MarkerSize',1)
  axis(axi); axis off;
end;


subplot(maxjjj,nrows,1);
title('Training');
subplot(maxjjj,nrows,2);
title('Test');
subplot(maxjjj,nrows,3);
title('SOM');
for i=1:length(nlfass),
  subplot(maxjjj,nrows,3+i);
  title(nlfass(i));
end;

