function pics = speech_show_err(filename, ndim, maxerro2, maxsigma, nlfass, ...
			 nlfahns, subpl);

somname = sprintf('%s_som',filename);
parzenname = sprintf('%s_parzen',filename);
lfaname = sprintf('%s_lfa',filename);
pics = [];

% show error pictures

for ssi=1:length(nlfass),
  nlfaname = sprintf('%s_nlfa_%d_%d',filename,nlfass(ssi), ...
		     nlfahns(ssi));
  if (length(nlfaname)==length('speech_patch_nlfa_15_30')),
    if (nlfaname=='speech_patch_nlfa_15_30')
      nlfaname = 'speech_patch2_nlfa_15_30';
    end;
  end;
  load(nlfaname);
  nlfaerrors(ssi,1) = erro2(end);
  nlfaerrors(ssi,2) = erro2b(end);
  fprintf('%s: iters:%d, kls:%f.\n', nlfaname, length(res.status.kls),...
	  res.status.kls(end));
  pics(1,ssi,1) = erro2(end);
  pics(1,ssi,2) = erro2b(end);
end;

load(lfaname)
for i=1:length(erro2),
  pics(2,i,1) = erro2(i);
  pics(2,i,2) = erro2b(i);
end;

load(somname)
erro2(find(erro2==0)) = 1e9;
nerro2 = size(erro2,1);
[i,si] = find(erro2 == min(min(erro2)));
si = si(1)
for i=1:nerro2,
  pics(3,i,1) = erro2(i,si);
  pics(3,i,2) = erro2b(i,si);
  pics(3,i,3) = alpha(i);
end;


%plot pics

subplot(subpl(1),subpl(2),subpl(3)+1);
plot(repmat(nlfass,2,1)',squeeze(pics(1,1:length(nlfass),1:2))) 
axis([1 max(nlfass) 0 maxerro2]);
if (subpl(3)==0),
  title('NFA');
end;

%load lineerro2neig2
subplot(subpl(1),subpl(2),subpl(3)+2);
plot( squeeze(pics(2,1:ndim,1:2)));
axis([1 ndim 0 maxerro2]);
if (subpl(3)==0),
  title('FA');
end;
%load sombigerro2neig2 
subplot(subpl(1),subpl(2),subpl(3)+3);
plot( [sqrt(1./(2*pics(3,1:nerro2,3)));sqrt(1./(2*pics(3,1:nerro2,3)))]',...
      squeeze(pics(3,1:nerro2,1:2)));
axis([0 maxsigma 0 maxerro2]);
if (subpl(3)==0),
  title('SOM');
end;

pics(find(pics==0)) = nan;
pics(find(pics==1e9)) = nan;
minit = squeeze(min(pics(:,:,1:2),[],2));
minit(1:3,:)'