for running=1:8,

%select from 8 different settings
if (running==1)
  filename = 'housing'; 
  speech = 0; permu = 1; patch = 0; randseed = 0; subplst = 0;
elseif (running==2)
  filename = 'housing2'; 
  speech = 0; permu = 1; patch = 0; randseed = 2; subplst = 4;
elseif (running==3)
  filename = 'housing3'; 
  speech = 0; permu = 1; patch = 0; randseed = 3; subplst = 7;
elseif (running==4)
  filename = 'housing4';
  speech = 0; permu = 1; patch = 0; randseed = 4; subplst = 11;
elseif (running==5)
  filename = 'speech_patch';
  speech = 1; permu = 0; patch = 1; randseed = 0; subplst = 0;
elseif (running==6)
  filename = 'speech';
  speech = 1; permu = 0; patch = 0; randseed = 0; subplst = 4;
elseif (running==7)
  filename = 'speech_patch_permu';
  speech = 1; permu = 1; patch = 1; randseed = 0; subplst = 7;
elseif (running==8)
  filename = 'speech_permu';
  speech = 1; permu = 1; patch = 0; randseed = 0; subplst = 11;
end;

%number of factors and hidden units for nfa
if (speech==0)
  nlfass = [1 2 3 5 7 9];
  nlfahns = [20 20 20 20 20 20];
else
  nlfass = [2 5 8 12 15 18];
  nlfahns = [30 30 30 30 30 30];
end;

%load data
[origdata, missing] = speech_data(speech, permu, patch, randseed);
[ndim, nsampl] = size(origdata);

%run algorithms
speech_run(filename, speech, permu, patch, randseed);

%show results
figure;
speech_show_projection(filename,origdata,missing,nlfass,nlfahns,speech);
figure;
speech_show_err(filename, ndim, 0.5+1.5*speech+patch, 2+2*speech,...
		nlfass, nlfahns, [2 7 subplst]);
if (speech)
  figure; clf;
  speech_show_rec(filename, origdata, missing, 15, 30);
end;
end;
