function scatplot(foundsources, inputs)
% SCATPLOT Plot a scatter plot of found sources vs. true inputs
%
%   Usage:
%     SCATPLOT(foundsources, inputs)
%     where both arguments are of type double

ninputs = size(inputs, 1);
noutputs = size(foundsources, 1);

for i=1:ninputs
  for j=1:noutputs
    subplot(noutputs, ninputs, i+ninputs*(j-1))
    plot(inputs(i, :), foundsources(j,:), '.', 'MarkerSize', 2)
    axis([-4 4 -4 4])
    set(gca, 'XTick', [])
    set(gca, 'YTick', [])
  end
end
