function [newsources, newnet, newpriors, newhypers] = ...
    scalesources(sources, net, priors, hypers)

scalefactors = sqrt(var(net.w1.e) + sum(net.w1.var));

newsources = diag(scalefactors) * sources;
newnet = net;
newnet.w1 = net.w1 * diag(1 ./ scalefactors);

newpriors = priors;
newpriors.src = priors.src + log(scalefactors');

newhypers = hypers;
newhypers.src = estimatehypers(newpriors.src);
