function [dcp_dwm, dcp_dwv, dcp_dbm, dcp_dbv] = netgradstop(x, dx, w, b)
% NETGRADSTOP Calculate partial derivatives of kldiv with respect to
%   network weights
%

% Antti Honkela 1999

nsampl = size(x, 2);

dcp_dwm = dx.e * x.e' + ...
	  2 * (dx.var * x.var') .* w.e + ...
	  sum(dx.multi, 3);
dcp_dwv = (dx.extra + dx.var) * (x.var + x.e .^ 2)';

dcp_dbm = dx.e * ones(nsampl,1);
dcp_dbv = (dx.var + dx.extra) * ones(nsampl,1);

