function [dcp_dwm, dcp_dwv, dcp_dbm, dcp_dbv] = ...
    netgradsprior(w, b, wprior, bprior)
% NETGRADSPRIOR Calculate the contribution of priors to partial
%   derivatives of kldiv with respect to network weights
%

% (c) Antti Honkela 1999-2000

wpvar = repmat(wprior, [size(w, 1) 1]);
bpexp = repmat(bprior.mean.e, size(b));
bpvar = repmat(normalvar(bprior.var), size(b));

dcp_dwm = w.e ./ wpvar;
dcp_dwv = .5 ./ wpvar;

dcp_dbm = (b.e - bpexp) ./ bpvar;
dcp_dbv = .5 ./ bpvar;
