function c = makenongaussinput(a, ex)
% MAKENONGAUSSINPUT generate nongaussian random numbers
%
%    Usage:
%      rnd = MAKENONGAUSSINPUT(A, WHICH)
%      generates random numbers with mean and variance as in
%      probdist A
%      The generated numbers are Gaussian with either sinh
%      (if WHICH == 1) or asinh (WHICH ~= 1) transformation applied.

% Antti Honkela 1999

b = randn(size(a));
b = (ex == 1) .* sinh(b) + (ex ~= 1) .* asinh(b);
vars = var(b', 1)';
c = b .* sqrt(a.var) ./ (sqrt(vars) * ones(1, size(a, 2))) + a.e;
