function c = kl_data(data, meanprior, varprior, dim, sizedata)

if nargin < 4
  dim = 2;
end
if nargin < 5
  sizedata = prod(size(data));
end

effvar = normalvar(varprior);

c = ...
    .5 * log(2*pi) * sizedata + ...
    sum(varprior.e) * sizedata / prod(size(varprior)) + ...
    .5 * sum(sum((data.e - meanprior.e).^2 + ...
		  data.var + meanprior.var, dim) ./ effvar);
