function v = kl_batch(fs, s, x, params, missing)
% KL_BATCH  calculate batch-dependent part of Kullback-Leibler divergence
%
%    Usage:
%      kl = kl_batch(fs, s, x, params)

% (c) Antti Honkela 1999-2000

sizedata = prod(size(fs));
fs_x = fs - x;
if nargin > 4
  fs_x(find(missing)) = probdist(0, 0);
  sizedata = sizedata - sum(sum(missing));
end;

v = kl_data(fs_x, probdist(0), params.noise, 2, sizedata) + ...
    kl_param(s, probdist(0), params.src, 2);
