function [dc_dsm, dc_dsv] = feedback_srcpriors(sources, srcparams)
% FEEDBACK_SRCPRIORS Calculate the contribution of source priors
%   to the gradients of the cost function with respect to source values
%

% (c) Antti Honkela 2000

sourcevar = normalvar(srcparams);

nsampl = size(sources, 2);

temp = sourcevar * ones(1, nsampl);

dc_dsm = sources.e ./ temp;
dc_dsv = .5 ./ temp;
