function param = estimatehypers(x)
% ESTIMATEHYPERS  Estimate highest level hyperparameter values for given data
%

% (c) 1999-2000 Antti Honkela and Harri Lappalainen

mv = mean(x.e);

seff = sum((x.e - mv).^2 + x.var) / (prod(size(x)) - 1);
varvar = .5 ./ prod(size(x));

param.mean = probdist(mv, seff / prod(size(x)));
param.var = probdist(varvar + .5*log(seff), varvar);
