function [d1, d2, d3] = dtanh(a)
% DTANH  Calculate three first derivatives of 'tanh'

% (c) Antti Honkela 1999-2000

y = tanh(a);
y2 = y .^ 2;

if nargout == 1
  d1 = 1 - y2;
else
  d1 = 1 - y2;
  d2 = -2 * y .* d1;
  d3 = 2 * d1 .* (3*y2 - 1);
end
