function [d1, d2, d3] = dasinh(a)
% DASINH  Calculate first three derivatives of 'asinh'
%

% (c) Antti Honkela 1999-2000

if nargout == 1
  d1 = (a.^2 + 1).^(-.5);
else
  d1 = (a.^2 + 1).^(-.5);
  d2 = -a .* d1.^3;
  d3 = (2 * a.^2 - 1) .* d1.^5;
end
