function v = cut(a, up, down)
% CUT  cut down values of matrix that are not between given limits
%
%   Usage:
%     B = CUT(A, up, down)
%     will return a matrix with all values in A greater than up
%     replaced by up and all values less than down replaced by down

% (c) Antti Honkela 1999-2000

v = a .* (a >= down) + down .* (a < down);
v = v .* (v <= up)   + up   .* (v > up);
