function c = vertcat(a, b)
% VERTCAT concatenate two probdist_alpha objects vertically
%
% Arrays of probdist_alphas are made by composing such arrays of respective
% expectations and variances.

% (c) Antti Honkela 1999-2000

if(nargin == 1)
  c = a;
else
  c = probdist_alpha([get(a, 'E'); get(b, 'E')], ...
		     [get(a, 'Var'); get(b, 'Var')], ...
		     [a.malpha; b.malpha], [a.valpha; b.valpha], ...
		     [a.msign; b.msign], [a.vsign; b.vsign]);
end
