function b = subsref(a,index)
% SUBSREF implement subscripted reference for probdist_alphas

% (c) Antti Honkela 1999-2000

switch index(1).type
 case '.'
  switch index(1).subs
   case 'e'
    b = get(a.probdist, 'E');
   case 'var'
    b = get(a.probdist, 'Var');
   case 'malpha'
    b = a.malpha;
   case 'valpha'
    b = a.valpha;
   case 'msign'
    b = a.msign;
   case 'vsign'
    b = a.vsign;
  end
 case '()'
  ex = get(a.probdist, 'E');
  var = get(a.probdist, 'Var');
  thissubs = index(1).subs;

  b = probdist_alpha(ex(thissubs{:}), var(thissubs{:}), ...
		     a.malpha(thissubs{:}), a.valpha(thissubs{:}), ...
		     a.msign(thissubs{:}), a.vsign(thissubs{:}));
 otherwise
  error('Unsupperted function')
end

% Handle other references recursively
if length(index) > 1
  b = subsref(b, index(2:end));
end
